/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransformFilter;
import com.jhlabs.math.Noise;
import java.awt.Rectangle;

public class RippleFilter
extends TransformFilter {
    static final long serialVersionUID = 5101667633854087384L;
    public static final int SINE = 0;
    public static final int SAWTOOTH = 1;
    public static final int TRIANGLE = 2;
    public static final int NOISE = 3;
    public double xAmplitude = 5.0;
    public double yAmplitude = 0.0;
    public double xWavelength = 16.0;
    public double yWavelength = 16.0;
    private int waveType;

    public void setXAmplitude(double d) {
        this.xAmplitude = d;
    }

    public double getXAmplitude() {
        return this.xAmplitude;
    }

    public void setXWavelength(double d) {
        this.xWavelength = d;
    }

    public double getXWavelength() {
        return this.xWavelength;
    }

    public void setYAmplitude(double d) {
        this.yAmplitude = d;
    }

    public double getYAmplitude() {
        return this.yAmplitude;
    }

    public void setYWavelength(double d) {
        this.yWavelength = d;
    }

    public double getYWavelength() {
        return this.yWavelength;
    }

    public void setWaveType(int n) {
        this.waveType = n;
    }

    public int getWaveType() {
        return this.waveType;
    }

    protected void transformSpace(Rectangle rectangle) {
        if (this.edgeAction == 0) {
            rectangle.x -= (int)this.xAmplitude;
            rectangle.width += (int)(2.0 * this.xAmplitude);
            rectangle.y -= (int)this.yAmplitude;
            rectangle.height += (int)(2.0 * this.yAmplitude);
        }
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        double d;
        double d2;
        double d3 = (double)n2 / this.xWavelength;
        double d4 = (double)n / this.yWavelength;
        switch (this.waveType) {
            default: {
                d2 = Math.sin(d3);
                d = Math.sin(d4);
                break;
            }
            case 1: {
                d2 = ImageMath.mod(d3, 1.0);
                d = ImageMath.mod(d4, 1.0);
                break;
            }
            case 2: {
                d2 = ImageMath.triangle(d3);
                d = ImageMath.triangle(d4);
                break;
            }
            case 3: {
                d2 = Noise.noise1(d3);
                d = Noise.noise1(d4);
            }
        }
        dArray[0] = (double)n + this.xAmplitude * d2;
        dArray[1] = (double)n2 + this.yAmplitude * d;
    }

    public String toString() {
        return "Distort/Ripple...";
    }
}

