/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.jwt.Jwt;
import com.okta.jwt.JwtVerificationException;
import com.okta.jwt.impl.DefaultJwt;
import com.okta.jwt.impl.jjwt.ClaimsValidator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtHandlerAdapter;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import java.time.Duration;
import java.util.Map;

abstract class TokenVerifierSupport {
    private final SigningKeyResolver keyResolver;
    private final String issuer;
    private final Duration leeway;

    TokenVerifierSupport(String issuer, Duration leeway, SigningKeyResolver signingKeyResolver) {
        this.issuer = issuer;
        this.leeway = leeway;
        this.keyResolver = signingKeyResolver;
    }

    protected JwtParser parser() {
        return Jwts.parser().setSigningKeyResolver(this.keyResolver).requireIssuer(this.issuer).setAllowedClockSkewSeconds(this.leeway.getSeconds());
    }

    protected Jwt decode(String token, JwtParser parser, ClaimsValidator claimsValidator) throws JwtVerificationException {
        if (!parser.isSigned(token)) {
            throw new JwtVerificationException("Token did not contain signature");
        }
        try {
            Jws jwt = (Jws)parser.parse(token, (JwtHandler)new OktaJwtHandler(claimsValidator));
            return new DefaultJwt(token, ((Claims)jwt.getBody()).getIssuedAt().toInstant(), ((Claims)jwt.getBody()).getExpiration().toInstant(), (Map)jwt.getBody());
        }
        catch (JwtException e) {
            throw new JwtVerificationException("Failed to parse token", (Throwable)e);
        }
    }

    SigningKeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    String getIssuer() {
        return this.issuer;
    }

    Duration getLeeway() {
        return this.leeway;
    }

    static class OktaJwtHandler
    extends JwtHandlerAdapter<Jws<Claims>> {
        private final ClaimsValidator claimsValidator;

        protected OktaJwtHandler(ClaimsValidator claimsValidator) {
            this.claimsValidator = claimsValidator;
        }

        public Jws<Claims> onClaimsJws(Jws<Claims> jws) {
            String alg = ((JwsHeader)jws.getHeader()).getAlgorithm();
            if (!SignatureAlgorithm.RS256.getValue().equals(alg)) {
                throw new UnsupportedJwtException("JWT Header 'alg' of [" + alg + "] is not supported, only RSA25 signatures are supported");
            }
            this.claimsValidator.validateClaims(jws);
            return jws;
        }
    }
}

