/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.ContainerSqlFragment;
import com.opengamma.elsql.SqlFragments;
import com.opengamma.elsql.SqlParams;

final class PagingSqlFragment
extends ContainerSqlFragment {
    private final String _offsetVariable;
    private final String _fetchVariable;

    PagingSqlFragment(String offsetVariable, String fetchVariable) {
        this._offsetVariable = offsetVariable;
        this._fetchVariable = fetchVariable;
    }

    @Override
    void toSQL(StringBuilder buf, SqlFragments fragments, SqlParams params, int[] loopIndex) {
        int oldLen = buf.length();
        super.toSQL(buf, fragments, params, loopIndex);
        int newLen = buf.length();
        String select = buf.substring(oldLen, newLen);
        if (select.startsWith("SELECT ")) {
            buf.setLength(oldLen);
            buf.append(this.applyPaging(select, fragments, params));
        }
    }

    String applyPaging(String selectToPage, SqlFragments fragments, SqlParams params) {
        int offset = PagingSqlFragment.extractVariableOrLiteral(params, this._offsetVariable);
        int fetchLimit = PagingSqlFragment.extractVariableOrLiteral(params, this._fetchVariable);
        return fragments.getConfig().addPaging(selectToPage, offset, fetchLimit == Integer.MAX_VALUE ? 0 : fetchLimit);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getFragments();
    }
}

