/*
 * Copyright (C) 2018 - present by OpenGamma Inc. and the OpenGamma group of companies
 *
 * Please see distribution for license.
 */
package com.opengamma.strata.calc.runner;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;

import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ResolvableCalculationTarget;

/**
 * A calculation target used when the actual target cannot be resolved.
 */
@BeanDefinition(style = "light", constructorScope = "package")
final class UnresolvableTarget implements CalculationTarget, ImmutableBean {

  /**
   * The target that could not be resolved.
   */
  @PropertyDefinition(validate = "notNull")
  private final ResolvableCalculationTarget target;
  /**
   * The failure message.
   */
  @PropertyDefinition(validate = "notNull")
  private final String message;

  //------------------------- AUTOGENERATED START -------------------------
  /**
   * The meta-bean for {@code UnresolvableTarget}.
   */
  private static final TypedMetaBean<UnresolvableTarget> META_BEAN =
      LightMetaBean.of(
          UnresolvableTarget.class,
          MethodHandles.lookup(),
          new String[] {
              "target",
              "message"},
          new Object[0]);

  /**
   * The meta-bean for {@code UnresolvableTarget}.
   * @return the meta-bean, not null
   */
  public static TypedMetaBean<UnresolvableTarget> meta() {
    return META_BEAN;
  }

  static {
    MetaBean.register(META_BEAN);
  }

  /**
   * Creates an instance.
   * @param target  the value of the property, not null
   * @param message  the value of the property, not null
   */
  UnresolvableTarget(
      ResolvableCalculationTarget target,
      String message) {
    JodaBeanUtils.notNull(target, "target");
    JodaBeanUtils.notNull(message, "message");
    this.target = target;
    this.message = message;
  }

  @Override
  public TypedMetaBean<UnresolvableTarget> metaBean() {
    return META_BEAN;
  }

  //-----------------------------------------------------------------------
  /**
   * Gets the target that could not be resolved.
   * @return the value of the property, not null
   */
  public ResolvableCalculationTarget getTarget() {
    return target;
  }

  //-----------------------------------------------------------------------
  /**
   * Gets the failure message.
   * @return the value of the property, not null
   */
  public String getMessage() {
    return message;
  }

  //-----------------------------------------------------------------------
  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj != null && obj.getClass() == this.getClass()) {
      UnresolvableTarget other = (UnresolvableTarget) obj;
      return JodaBeanUtils.equal(target, other.target) &&
          JodaBeanUtils.equal(message, other.message);
    }
    return false;
  }

  @Override
  public int hashCode() {
    int hash = getClass().hashCode();
    hash = hash * 31 + JodaBeanUtils.hashCode(target);
    hash = hash * 31 + JodaBeanUtils.hashCode(message);
    return hash;
  }

  @Override
  public String toString() {
    StringBuilder buf = new StringBuilder(96);
    buf.append("UnresolvableTarget{");
    buf.append("target").append('=').append(JodaBeanUtils.toString(target)).append(',').append(' ');
    buf.append("message").append('=').append(JodaBeanUtils.toString(message));
    buf.append('}');
    return buf.toString();
  }

  //-------------------------- AUTOGENERATED END --------------------------
}
