/*
 * Copyright (C) 2015 - present by OpenGamma Inc. and the OpenGamma group of companies
 *
 * Please see distribution for license.
 */
package com.opengamma.strata.data.scenario;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;

import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.impl.light.LightMetaBean;

import com.opengamma.strata.basics.ReferenceData;

/**
 * A scenario perturbation that returns its input unchanged and has a scenario count of one.
 * 
 * @param <T>  the type of handled by the perturbation
 */
@BeanDefinition(style = "light")
final class NoOpScenarioPerturbation<T>
    implements ScenarioPerturbation<T>, ImmutableBean, Serializable {

  /** The single shared instance of this class. */
  static final ScenarioPerturbation<Object> INSTANCE = new NoOpScenarioPerturbation<>();

  //-------------------------------------------------------------------------
  @Override
  public MarketDataBox<T> applyTo(MarketDataBox<T> marketData, ReferenceData refData) {
    return marketData;
  }

  @Override
  public int getScenarioCount() {
    // A box with one scenario can be used for any number of scenarios
    return 1;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Class<T> getMarketDataType() {
    return (Class<T>) Object.class;
  }

  //------------------------- AUTOGENERATED START -------------------------
  /**
   * The meta-bean for {@code NoOpScenarioPerturbation}.
   */
  private static final MetaBean META_BEAN =
      LightMetaBean.of(NoOpScenarioPerturbation.class, MethodHandles.lookup());

  /**
   * The meta-bean for {@code NoOpScenarioPerturbation}.
   * @return the meta-bean, not null
   */
  public static MetaBean meta() {
    return META_BEAN;
  }

  static {
    MetaBean.register(META_BEAN);
  }

  /**
   * The serialization version id.
   */
  private static final long serialVersionUID = 1L;

  private NoOpScenarioPerturbation() {
  }

  @Override
  @SuppressWarnings("unchecked")
  public TypedMetaBean<NoOpScenarioPerturbation<T>> metaBean() {
    return (TypedMetaBean<NoOpScenarioPerturbation<T>>) META_BEAN;
  }

  //-----------------------------------------------------------------------
  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj != null && obj.getClass() == this.getClass()) {
      return true;
    }
    return false;
  }

  @Override
  public int hashCode() {
    int hash = getClass().hashCode();
    return hash;
  }

  @Override
  public String toString() {
    StringBuilder buf = new StringBuilder(32);
    buf.append("NoOpScenarioPerturbation{");
    buf.append('}');
    return buf.toString();
  }

  //-------------------------- AUTOGENERATED END --------------------------
}
