/*
 * Copyright (C) 2017 - present by OpenGamma Inc. and the OpenGamma group of companies
 *
 * Please see distribution for license.
 */
package com.opengamma.strata.product.common;

/**
 * Identifiers for common exchanges.
 * <p>
 * The identifier names are ISO Market Identifier Codes (MICs).
 */
public final class ExchangeIds {

  /** Eurex Clearing AG. */
  public static final ExchangeId ECAG = ExchangeId.of("ECAG");

  /** Chicago Mercantile Exchange (CME). */
  public static final ExchangeId XCME = ExchangeId.of("XCME");

  /** Chicago Board of Trade (CBOT). */
  public static final ExchangeId XCBT = ExchangeId.of("XCBT");

  /** Chicago Board Options Exchange. */
  public static final ExchangeId XCBO = ExchangeId.of("XCBO");

  /** Cboe Clear Digital. */
  public static final ExchangeId XCBD = ExchangeId.of("XCBD");

  /** New York Mercantile Exchange (NYMEX). */
  public static final ExchangeId XNYM = ExchangeId.of("XNYM");

  /** Commodities Exchange Center (COMEX). */
  public static final ExchangeId XCEC = ExchangeId.of("XCEC");

  /** ICE Futures Europe - Equity Products Division. */
  public static final ExchangeId IFLO = ExchangeId.of("IFLO");

  /** ICE Futures Europe - Financial Products Division. */
  public static final ExchangeId IFLL = ExchangeId.of("IFLL");

  /** ICE Futures Europe - European Utilities Division. */
  public static final ExchangeId IFUT = ExchangeId.of("IFUT");

  /** ICE Futures Europe - Agricultural Products Division. */
  public static final ExchangeId IFLX = ExchangeId.of("IFLX");

  /** ICE Futures Europe - Oil and Refined Products Division. */
  public static final ExchangeId IFEN = ExchangeId.of("IFEN");

  /** ICE Futures U.S. */
  public static final ExchangeId IFUS = ExchangeId.of("IFUS");

  /** Osaka Exchange. */
  public static final ExchangeId XOSE = ExchangeId.of("XOSE");

  /** Hong Kong Exchanges And Clearing Ltd. */
  public static final ExchangeId XHKG = ExchangeId.of("XHKG");

  /** Hong Kong Futures Exchange Ltd. */
  public static final ExchangeId XHKF = ExchangeId.of("XHKF");

  /** Singapore Exchange Ltd. */
  public static final ExchangeId XSES = ExchangeId.of("XSES");

  /** Australian Securities Exchange. */
  public static final ExchangeId XASX = ExchangeId.of("XASX");

  /** ASX - Trade24 (formerly Sydney Futures Exchange). */
  public static final ExchangeId XSFE = ExchangeId.of("XSFE");

  /** New Zealand Futures & Options. */
  public static final ExchangeId NZFX = ExchangeId.of("NZFX");

  /** Warsaw Stock Exchange. */
  public static final ExchangeId XWAR = ExchangeId.of("XWAR");

  /** Johannesburg Stock Exchange. */
  public static final ExchangeId XJSE = ExchangeId.of("XJSE");

  /** JSE - Equity Derivatives Market. */
  public static final ExchangeId XSAF = ExchangeId.of("XSAF");

  /** Mercado Español de Futuros Financiero (MEFF). */
  public static final ExchangeId XMRV = ExchangeId.of("XMRV");

  /** Meff Power Derivatives Exchange. */
  public static final ExchangeId XMPW = ExchangeId.of("XMPW");

  /** Bursa Malaysia. */
  public static final ExchangeId XKLS = ExchangeId.of("XKLS");

  /** London Metal Exchange. */
  public static final ExchangeId XLME = ExchangeId.of("XLME");

  /** Minneapolis Grain Exchange. */
  public static final ExchangeId XMGE = ExchangeId.of("XMGE");

  /** The Montreal Exchange. */
  public static final ExchangeId XMOD = ExchangeId.of("XMOD");

  /** Tokyo Financial Exchange. */
  public static final ExchangeId XTFF = ExchangeId.of("XTFF");

  /** Tokyo Commodity Exchange. */
  public static final ExchangeId XTKT = ExchangeId.of("XTKT");

  /** Tokyo Stock Exchange. */
  public static final ExchangeId XTKS = ExchangeId.of("XTKS");

  /** Borsa Istanbul Exchange */
  public static final ExchangeId XFNO = ExchangeId.of("XFNO");

  /** Euronext Exchange - Paris MATIF */
  public static final ExchangeId XMAT = ExchangeId.of("XMAT");

  /** Euronext Exchange - Paris */
  public static final ExchangeId XPAR = ExchangeId.of("XPAR");

  /** Euronext Exchange - Paris MONEP */
  public static final ExchangeId XMON = ExchangeId.of("XMON");

  /** Korea Exchange (Futures Market) */
  public static final ExchangeId XKFE = ExchangeId.of("XKFE");

  /** European Energy Exchange. */
  public static final ExchangeId XEEE = ExchangeId.of("XEEE");

  /** APX Power Nl. */
  public static final ExchangeId NLPX = ExchangeId.of("NLPX");

  /** Central Eastern European Gas Exchange. */
  public static final ExchangeId XGAS = ExchangeId.of("XGAS");

  /** Powernext. */
  public static final ExchangeId XPOW = ExchangeId.of("XPOW");

  /** Hungarian Power Exchange. */
  public static final ExchangeId HUPX = ExchangeId.of("HUPX");

  /** Hungarian Derivative Energy Exchange. */
  public static final ExchangeId HUDX = ExchangeId.of("HUDX");

  /** Gaspoint Nordic. */
  public static final ExchangeId NPGA = ExchangeId.of("NPGA");

  /** Norexeco. */
  public static final ExchangeId NEXO = ExchangeId.of("NEXO");

  /** Nodal Exchange. */
  public static final ExchangeId NODX = ExchangeId.of("NODX");

  /** Zhengzhou Commodity Exchange. */
  public static final ExchangeId XZCE = ExchangeId.of("XZCE");

  /** Nasdaq Commodity Exchange. */
  public static final ExchangeId NORX = ExchangeId.of("NORX");

  /** OMIClear Exchange. */
  public static final ExchangeId OMIC = ExchangeId.of("OMIC");

  /** National Stock Exchange Of India. */
  public static final ExchangeId XNSE = ExchangeId.of("XNSE");

  /** NSE International Exchange. */
  public static final ExchangeId INSE = ExchangeId.of("INSE");

  //-------------------------------------------------------------------------
  /**
   * Restricted constructor.
   */
  private ExchangeIds() {
  }

}
