/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.BundledPostgresBinaryResolver;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import com.opentable.db.postgres.embedded.EmbeddedUtil;
import com.opentable.db.postgres.embedded.PgBinaryResolver;
import com.opentable.db.postgres.embedded.PgDirectoryResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncompressBundleDirectoryResolver
implements PgDirectoryResolver {
    private static volatile UncompressBundleDirectoryResolver DEFAULT_INSTANCE;
    private static final Logger LOG;
    private final Lock prepareBinariesLock = new ReentrantLock();
    private final PgBinaryResolver pgBinaryResolver;
    private final Map<PgBinaryResolver, File> prepareBinaries = new HashMap<PgBinaryResolver, File>();

    public static synchronized UncompressBundleDirectoryResolver getDefault() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new UncompressBundleDirectoryResolver(new BundledPostgresBinaryResolver());
        }
        return DEFAULT_INSTANCE;
    }

    public UncompressBundleDirectoryResolver(PgBinaryResolver pgBinaryResolver) {
        this.pgBinaryResolver = pgBinaryResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getDirectory(Optional<File> overrideWorkingDirectory) {
        this.prepareBinariesLock.lock();
        try {
            File pgDir;
            block48: {
                InputStream pgBinary;
                if (this.prepareBinaries.containsKey(this.pgBinaryResolver) && this.prepareBinaries.get(this.pgBinaryResolver).exists()) {
                    File file = this.prepareBinaries.get(this.pgBinaryResolver);
                    return file;
                }
                String system = EmbeddedUtil.getOS();
                String machineHardware = EmbeddedUtil.getArchitecture();
                LOG.info("Detected a {} {} system", (Object)system, (Object)machineHardware);
                try {
                    pgBinary = this.pgBinaryResolver.getPgBinary(system, machineHardware);
                }
                catch (IOException e) {
                    throw new ExceptionInInitializerError(e);
                }
                if (pgBinary == null) {
                    throw new IllegalStateException("No Postgres binary found for " + system + " / " + machineHardware);
                }
                try (DigestInputStream pgArchiveData = new DigestInputStream(pgBinary, MessageDigest.getInstance("MD5"));
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    IOUtils.copy((InputStream)pgArchiveData, (OutputStream)baos);
                    pgArchiveData.close();
                    String pgDigest = Hex.encodeHexString((byte[])pgArchiveData.getMessageDigest().digest());
                    File workingDirectory = overrideWorkingDirectory.isPresent() ? overrideWorkingDirectory.get() : EmbeddedUtil.getWorkingDirectory();
                    pgDir = new File(workingDirectory, String.format("PG-%s", pgDigest));
                    EmbeddedUtil.mkdirs(pgDir);
                    File unpackLockFile = new File(pgDir, "epg-lock");
                    File pgDirExists = new File(pgDir, ".exists");
                    if (pgDirExists.exists()) break block48;
                    try (FileOutputStream lockStream = new FileOutputStream(unpackLockFile);
                         FileLock unpackLock = lockStream.getChannel().tryLock();){
                        if (unpackLock != null) {
                            try {
                                if (pgDirExists.exists()) {
                                    throw new IllegalStateException("unpack lock acquired but .exists file is present " + pgDirExists);
                                }
                                LOG.info("Extracting Postgres...");
                                try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                                    EmbeddedUtil.extractTxz(bais, pgDir.getPath());
                                }
                                if (!pgDirExists.createNewFile()) {
                                    throw new IllegalStateException("couldn't make .exists file " + pgDirExists);
                                }
                                break block48;
                            }
                            catch (Exception e) {
                                LOG.error("while unpacking Postgres", (Throwable)e);
                            }
                            break block48;
                        }
                        int maxAttempts = 60;
                        while (!pgDirExists.exists() && --maxAttempts > 0) {
                            Thread.sleep(1000L);
                        }
                        if (!pgDirExists.exists()) {
                            throw new IllegalStateException("Waited 60 seconds for postgres to be unpacked but it never finished!");
                        }
                    }
                    finally {
                        if (unpackLockFile.exists() && !unpackLockFile.delete()) {
                            LOG.error("could not remove lock file {}", (Object)unpackLockFile.getAbsolutePath());
                        }
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    throw new ExceptionInInitializerError(e);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new ExceptionInInitializerError(ie);
                }
            }
            this.prepareBinaries.put(this.pgBinaryResolver, pgDir);
            LOG.info("Postgres binaries at {}", (Object)pgDir);
            File file = pgDir;
            return file;
        }
        finally {
            this.prepareBinariesLock.unlock();
        }
    }

    static {
        LOG = LoggerFactory.getLogger(EmbeddedPostgres.class);
    }
}

