/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaUIElement;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import com.opera.core.systems.scope.services.IDesktopUtils;
import com.opera.core.systems.scope.services.ums.SystemInputManager;
import java.awt.Point;
import java.util.ArrayList;

public class QuickWidget
extends OperaUIElement {
    private final DesktopWmProtos.QuickWidgetInfo info;
    private final int parentWindowId;

    public QuickWidget(IDesktopUtils desktopUtils, SystemInputManager inputManager, DesktopWmProtos.QuickWidgetInfo info, int parentWindowId) {
        super(inputManager, desktopUtils);
        this.info = info;
        this.parentWindowId = parentWindowId;
    }

    public int getParentWindowId() {
        return this.parentWindowId;
    }

    private Point intersection(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        double dem = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        double xi = (double)((x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4)) / dem;
        double yi = (double)((x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4)) / dem;
        if (((double)x1 - xi) * (xi - (double)x2) >= 0.0 && ((double)x3 - xi) * (xi - (double)x4) >= 0.0 && ((double)y1 - yi) * (yi - (double)y2) >= 0.0 && ((double)y3 - yi) * (yi - (double)y4) >= 0.0) {
            return new Point((int)xi, (int)yi);
        }
        return null;
    }

    private Point intersection(int x1, int y1, int x2, int y2, DesktopWmProtos.DesktopWindowRect rect) {
        Point bottom = this.intersection(x1, y1, x2, y2, rect.getX(), rect.getY(), rect.getX() + rect.getHeight(), rect.getY());
        if (bottom != null) {
            return bottom;
        }
        Point right = this.intersection(x1, y1, x2, y2, rect.getX() + rect.getWidth(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
        if (right != null) {
            return right;
        }
        Point top = this.intersection(x1, y1, x2, y2, rect.getX(), rect.getY() + rect.getHeight(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
        if (top != null) {
            return top;
        }
        Point left = this.intersection(x1, y1, x2, y2, rect.getX(), rect.getY(), rect.getX(), rect.getY() + rect.getHeight());
        if (left != null) {
            return left;
        }
        return null;
    }

    public void dragAndDropOn(QuickWidget widget, DropPosition dropPos) {
        Point currentLocation = this.getCenterLocation();
        Point dropPoint = this.getDropPoint(widget, dropPos);
        ArrayList<SystemInputProtos.ModifierPressed> alist = new ArrayList<SystemInputProtos.ModifierPressed>();
        alist.add(SystemInputProtos.ModifierPressed.NONE);
        this.getSystemInputManager().mouseDown(currentLocation, SystemInputProtos.MouseInfo.MouseButton.LEFT, alist);
        this.getSystemInputManager().mouseMove(dropPoint, SystemInputProtos.MouseInfo.MouseButton.LEFT, alist);
        this.getSystemInputManager().mouseUp(dropPoint, SystemInputProtos.MouseInfo.MouseButton.LEFT, alist);
    }

    private Point getDropPoint(QuickWidget element, DropPosition pos) {
        Point dropIntersectPoint;
        Point dropPoint = new Point(element.getCenterLocation().x, element.getCenterLocation().y);
        if (pos == DropPosition.CENTER) {
            return dropPoint;
        }
        Point dragPoint = new Point(this.getCenterLocation().x, this.getCenterLocation().y);
        Point dragIntersectPoint = this.intersection(dragPoint.x, dragPoint.y, dropPoint.x, dropPoint.y, this.getRect());
        if (dragIntersectPoint != null && (dropIntersectPoint = this.intersection(dragPoint.x, dragPoint.y, dropPoint.x, dropPoint.y, element.getRect())) != null) {
            if (pos == DropPosition.EDGE) {
                return dropIntersectPoint;
            }
            return new Point((dragIntersectPoint.x + dropIntersectPoint.x) / 2, (dragIntersectPoint.y + dropIntersectPoint.y) / 2);
        }
        return null;
    }

    public String getName() {
        return this.info.getName();
    }

    public String getText() {
        return this.getDesktopUtils().removeCR(this.info.getText());
    }

    public String getVisibleText() {
        return this.getDesktopUtils().removeCR(this.info.getVisibleText());
    }

    public String getAdditionalText() {
        return this.getDesktopUtils().removeCR(this.info.getAdditionalText());
    }

    public boolean isDefault() {
        return this.info.getDefaultLook();
    }

    public boolean hasFocusedLook() {
        return this.info.getFocusedLook();
    }

    public boolean isEnabled() {
        return this.info.getEnabled();
    }

    public boolean isSelected() {
        return this.info.getValue() == 1;
    }

    public boolean isSelected(String stringId) {
        String text = this.getDesktopUtils().getString(stringId, true);
        return text.equals(this.info.getText());
    }

    public boolean isVisible() {
        return this.info.getVisible();
    }

    public DesktopWmProtos.QuickWidgetInfo.QuickWidgetType getType() {
        return this.info.getType();
    }

    public DesktopWmProtos.DesktopWindowRect getRect() {
        return this.info.getRect();
    }

    public int getRow() {
        return this.info.getRow();
    }

    public int getColumn() {
        return this.info.getCol();
    }

    protected int getValue() {
        return this.info.getValue();
    }

    public String getParentName() {
        return this.info.getParent();
    }

    public String toString() {
        return "QuickWidget " + this.getName();
    }

    public String toFullString() {
        return "QuickWidget\n       Widget name: " + this.getName() + "\n" + "    visible: " + this.isVisible() + "\n" + "       text: " + this.getText() + "\n" + "      state: " + this.getValue() + "\n" + "    enabled: " + this.isEnabled() + "\n" + "    default: " + this.isDefault() + "\n" + "    focused: " + this.hasFocusedLook() + "\n" + "          x: " + this.getRect().getX() + "\n" + "          y: " + this.getRect().getY() + "\n" + "      width: " + this.getRect().getWidth() + "\n" + "     height: " + this.getRect().getHeight() + " \n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DropPosition {
        CENTER(0),
        EDGE(1),
        BETWEEN(2);

        private Integer value;

        private DropPosition(int value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

