/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner;

import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.arguments.OperaCoreArguments;
import com.opera.core.systems.arguments.OperaDesktopArguments;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.runner.OperaRunnerSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.selenium.io.TemporaryFilesystem;

public class OperaRunner
implements com.opera.core.systems.runner.interfaces.OperaRunner {
    protected static Logger logger = Logger.getLogger(OperaRunner.class.getName());
    protected OperaRunnerSettings settings;
    private final ReentrantLock lock = new ReentrantLock();
    private ProcessBuilder processBuilder;
    private Process process = null;

    public OperaRunner() {
        this(OperaRunnerSettings.getDefaultSettings());
    }

    public OperaRunner(OperaRunnerSettings settings) {
        this.settings = settings;
        OperaCoreArguments arguments = settings.getProduct().is(OperaProduct.DESKTOP) ? new OperaDesktopArguments() : new OperaCoreArguments();
        String profile = settings.getProfile();
        if (profile == null) {
            profile = TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera-profile", "").getAbsolutePath();
            this.settings.setProfile(profile);
            arguments.add("-pd", profile);
        } else if (!profile.isEmpty()) {
            arguments.add("-pd", profile);
        }
        if (this.settings.supportsDebugProxy()) {
            arguments.add("debugproxy", this.settings.getHost() + ":" + this.settings.getPort());
        }
        arguments.add("autotestmode");
        arguments.merge(this.settings.getArguments());
        this.settings.setArguments(arguments);
        logger.config("Opera arguments: " + this.settings.getArguments().getArgumentsAsStringList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOpera() {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            this.process = this.processBuilder.start();
            OperaRunner.pipe(this.process.getErrorStream(), System.err);
            OperaRunner.pipe(this.process.getInputStream(), System.out);
        }
        catch (IOException iOException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopOpera() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return;
            }
        }
        finally {
            this.process = null;
            this.lock.unlock();
        }
    }

    public boolean isOperaRunning() {
        return this.isOperaRunning(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperaRunning(int processID) {
        this.lock.lock();
        try {
            if (this.process == null) {
                boolean bl = false;
                return bl;
            }
            this.process.exitValue();
            boolean bl = false;
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasOperaCrashed() {
        return false;
    }

    public String getOperaCrashlog() {
        return "";
    }

    public void shutdown() {
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static void pipe(final InputStream src, final PrintStream dest) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        dest.write(buffer, 0, n);
                        n = src.read(buffer);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }
}

