/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ESDebuggerCommand implements ICommand
{
    LIST_RUNTIMES(1),
    EVAL(3),
    INSPECT_DOM(13),
    EXAMINE_OBJECTS(4),
    SET_CONFIGURATION(10),
    RELEASE_OBJECTS(29),
    RUNTIME_STARTED(14),
    RUNTIME_STOPPED(15),
    NEW_SCRIPT(16),
    THREAD_STARTED(17),
    THREAD_FINISHED(18),
    THREAD_STOPPED_AT(19),
    HANDLE_EVENT(20),
    OBJECT_SELECTED(21),
    PARSE_ERROR(28),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, ESDebuggerCommand> lookup;

    private ESDebuggerCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "ecmascript-debugger";
    }

    public static ESDebuggerCommand get(int code) {
        ESDebuggerCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, ESDebuggerCommand>();
        for (ESDebuggerCommand command : EnumSet.allOf(ESDebuggerCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

