/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExecCommand implements ICommand
{
    EXEC(1),
    GET_ACTION_LIST(2),
    SETUP_SCREEN_WATCHER(3),
    SEND_MOUSE_ACTION(5),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, ExecCommand> lookup;

    private ExecCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "exec";
    }

    public static ExecCommand get(int code) {
        ExecCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, ExecCommand>();
        for (ExecCommand command : EnumSet.allOf(ExecCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

