/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SystemInputCommand implements ICommand
{
    CLICK(1),
    KEYPRESS(2),
    KEYUP(3),
    KEYDOWN(4),
    MOUSEDOWN(5),
    MOUSEUP(6),
    MOUSEMOVE(7),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, SystemInputCommand> lookup;

    private SystemInputCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "system-input";
    }

    public static SystemInputCommand get(int code) {
        SystemInputCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, SystemInputCommand>();
        for (SystemInputCommand command : EnumSet.allOf(SystemInputCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

