/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.CoreUtilsCommand;
import com.opera.core.systems.scope.protos.CoreProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ICoreUtils;
import org.openqa.selenium.UnsupportedCommandException;

public class CoreUtils
extends AbstractService
implements ICoreUtils {
    private boolean supportsMeta = false;
    private CoreProtos.BrowserInformation browserInformation;

    public CoreUtils(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "core";
        if (!this.isVersionInRange(version, "1.2", serviceName)) {
            this.supportsMeta = true;
        }
        services.setCoreUtils(this);
    }

    public void init() {
        if (this.supportsMeta) {
            this.browserInformation = this.getBrowserInformation();
        }
    }

    public boolean hasMetaInformation() {
        return this.supportsMeta;
    }

    public String getCoreVersion() {
        if (!this.browserInformation.hasCoreVersion()) {
            throw new UnsupportedCommandException("not available in this product");
        }
        return this.browserInformation.getCoreVersion();
    }

    public String getOperatingSystem() {
        if (!this.browserInformation.hasOperatingSystem()) {
            throw new UnsupportedCommandException("not available in this product");
        }
        return this.browserInformation.getOperatingSystem();
    }

    public String getProduct() {
        if (!this.browserInformation.hasProduct()) {
            throw new UnsupportedCommandException("not available in this product");
        }
        return this.browserInformation.getProduct();
    }

    public String getBinaryPath() {
        if (!this.browserInformation.hasBinaryPath()) {
            throw new UnsupportedCommandException("not available in this product");
        }
        return this.browserInformation.getBinaryPath();
    }

    public String getUserAgent() {
        if (!this.browserInformation.hasUserAgent()) {
            throw new UnsupportedCommandException("not available in this product");
        }
        return this.browserInformation.getUserAgent();
    }

    public Integer getProcessID() {
        if (!this.browserInformation.hasProcessID()) {
            throw new UnsupportedCommandException("not available in this product");
        }
        return this.browserInformation.getProcessID();
    }

    private CoreProtos.BrowserInformation getBrowserInformation() {
        UmsProtos.Response response = this.executeCommand(CoreUtilsCommand.GET_BROWSER_INFORMATION, null);
        CoreProtos.BrowserInformation.Builder builder = CoreProtos.BrowserInformation.newBuilder();
        CoreUtils.buildPayload(response, builder);
        return builder.build();
    }
}

