/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.scope.AbstractEcmascriptService;
import com.opera.core.systems.scope.ESDebuggerCommand;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.apache.commons.jxpath.Pointer;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcmaScriptDebugger
extends AbstractEcmascriptService
implements IEcmaScriptDebugger {
    private AtomicStampedReference<EsdbgProtos.RuntimeInfo> runtime = new AtomicStampedReference<Object>(null, 0);
    private ConcurrentMap<Integer, EsdbgProtos.RuntimeInfo> runtimesList = new ConcurrentHashMap<Integer, EsdbgProtos.RuntimeInfo>();
    private RuntimeNode root;

    public EcmaScriptDebugger(ScopeServices services, String version) {
        super(services, version);
        services.setDebugger(this);
        this.windowManager = services.getWindowManager();
        this.services = services;
        this.resetCounters();
        this.currentFramePath = "_top";
    }

    @Override
    public int getRuntimeId() {
        return this.runtime.getStamp();
    }

    @Override
    public void setRuntime(EsdbgProtos.RuntimeInfo runtime) {
        this.runtime.set(runtime, runtime.getRuntimeID());
        this.activeWindowId = runtime.getWindowID();
    }

    @Override
    public void addRuntime(EsdbgProtos.RuntimeInfo runtime) {
        this.runtimesList.put(runtime.getRuntimeID(), runtime);
    }

    @Override
    public void removeRuntime(int runtimeId) {
        this.runtimesList.remove(runtimeId);
    }

    private List<EsdbgProtos.RuntimeInfo> getRuntimesList() {
        int windowId = this.services.getWindowManager().getActiveWindowId();
        Iterator<?> iterator = this.xpathIterator(this.runtimesList.values(), "/.[windowID='" + windowId + "']");
        ArrayList<EsdbgProtos.RuntimeInfo> runtimes = new ArrayList<EsdbgProtos.RuntimeInfo>();
        while (iterator.hasNext()) {
            runtimes.add((EsdbgProtos.RuntimeInfo)((Pointer)iterator.next()).getNode());
        }
        return runtimes;
    }

    @Override
    public void init() {
        EsdbgProtos.Configuration.Builder configuration = EsdbgProtos.Configuration.newBuilder();
        configuration.setStopAtScript(false);
        configuration.setStopAtAbort(false);
        configuration.setStopAtException(false);
        configuration.setStopAtError(false);
        configuration.setStopAtDebuggerStatement(false);
        configuration.setStopAtGc(false);
        this.executeCommand(ESDebuggerCommand.SET_CONFIGURATION, (AbstractMessage.Builder<?>)configuration);
        if (!this.updateRuntime()) {
            throw new WebDriverException("Could not find a runtime for script injection");
        }
        this.executeJavascript("return 1;", true);
    }

    @Override
    public boolean updateRuntime() {
        EsdbgProtos.RuntimeInfo activeRuntime = this.findRuntime();
        if (activeRuntime != null) {
            this.setRuntime(activeRuntime);
            return true;
        }
        return false;
    }

    protected List<EsdbgProtos.RuntimeInfo> listRuntimes(boolean allRuntimes) {
        EsdbgProtos.RuntimeSelection.Builder selection = EsdbgProtos.RuntimeSelection.newBuilder();
        selection.setAllRuntimes(allRuntimes);
        UmsProtos.Response response = this.executeCommand(ESDebuggerCommand.LIST_RUNTIMES, (AbstractMessage.Builder<?>)selection);
        EsdbgProtos.RuntimeList.Builder builder = EsdbgProtos.RuntimeList.newBuilder();
        EcmaScriptDebugger.buildPayload(response, builder);
        return builder.build().getRuntimeListList();
    }

    protected void createAllRuntimes() {
        List<EsdbgProtos.RuntimeInfo> runtimes = this.listRuntimes(true);
        this.runtimesList.clear();
        for (EsdbgProtos.RuntimeInfo info : runtimes) {
            this.runtimesList.put(info.getRuntimeID(), info);
        }
    }

    @Override
    public Object scriptExecutor(String script, Object ... params) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        String toSend = this.buildEvalString(elements, script, params);
        EsdbgProtos.EvalData.Builder evalBuilder = this.buildEval(toSend, this.getRuntimeId());
        for (WebElement webElement : elements) {
            EsdbgProtos.EvalData.Variable variable = this.buildVariable(webElement.toString(), ((OperaWebElement)webElement).getObjectId());
            evalBuilder.addVariableList(variable);
        }
        UmsProtos.Response response = this.executeCommand(ESDebuggerCommand.EVAL, (AbstractMessage.Builder<?>)evalBuilder);
        if (response == null) {
            throw new WebDriverException("Internal error while executing script");
        }
        EsdbgProtos.EvalResult result = this.parseEvalData(response);
        Object parsed = this.parseEvalReply(result);
        if (parsed instanceof EsdbgProtos.ObjectValue) {
            EsdbgProtos.ObjectValue data = (EsdbgProtos.ObjectValue)parsed;
            return new ScriptResult(data.getObjectID(), data.getName());
        }
        return parsed;
    }

    private EsdbgProtos.EvalResult parseEvalData(UmsProtos.Response response) {
        EsdbgProtos.EvalResult.Builder builder = EsdbgProtos.EvalResult.newBuilder();
        EcmaScriptDebugger.buildPayload(response, builder);
        return builder.build();
    }

    protected final EsdbgProtos.EvalData.Builder buildEval(String using, int runtimeId) {
        EsdbgProtos.EvalData.Builder eval = EsdbgProtos.EvalData.newBuilder();
        eval.setRuntimeID(runtimeId);
        eval.setFrameIndex(0);
        eval.setThreadID(0);
        eval.setScriptData(using);
        return eval;
    }

    protected final EsdbgProtos.EvalData.Variable buildVariable(String name, int objectId) {
        EsdbgProtos.EvalData.Variable.Builder variable = EsdbgProtos.EvalData.Variable.newBuilder();
        variable.setName(name);
        variable.setObjectID(objectId);
        return variable.build();
    }

    protected UmsProtos.Response eval(String using, int runtimeId, EsdbgProtos.EvalData.Variable ... variables) {
        EsdbgProtos.EvalData.Builder builder = this.buildEval(using, runtimeId);
        builder.addAllVariableList(Arrays.asList(variables));
        UmsProtos.Response response = this.executeCommand(ESDebuggerCommand.EVAL, (AbstractMessage.Builder<?>)builder, OperaIntervals.SCRIPT_TIMEOUT.getValue());
        if (response == null && (long)this.retries < OperaIntervals.SCRIPT_RETRY.getValue()) {
            ++this.retries;
            this.sleepDuration += this.sleepDuration;
            EcmaScriptDebugger.sleep(this.sleepDuration);
            this.recover();
            return this.eval(using, variables);
        }
        if ((long)this.retries >= OperaIntervals.SCRIPT_RETRY.getValue()) {
            this.resetCounters();
            throw new WebDriverException("No response on executing JS command");
        }
        this.resetCounters();
        return response;
    }

    protected UmsProtos.Response eval(String using, EsdbgProtos.EvalData.Variable ... variables) {
        return this.eval(using, this.getRuntimeId(), variables);
    }

    @Override
    public Object executeScript(String using, boolean responseExpected) {
        return this.executeScript(using, responseExpected, this.getRuntimeId());
    }

    public Object executeScript(String using, boolean responseExpected, int runtimeId) {
        UmsProtos.Response reply = this.eval(using, runtimeId, new EsdbgProtos.EvalData.Variable[0]);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(reply)) : null;
    }

    @Override
    public Integer getObject(String using) {
        EsdbgProtos.EvalResult reply = this.parseEvalData(this.eval(using, new EsdbgProtos.EvalData.Variable[0]));
        return reply.getType().equals("object") ? Integer.valueOf(reply.getObjectValue().getObjectID()) : null;
    }

    protected Integer getObject(String using, int runtimeId) {
        EsdbgProtos.EvalResult reply = this.parseEvalData(this.eval(using, runtimeId, new EsdbgProtos.EvalData.Variable[0]));
        return reply.getType().equals("object") ? Integer.valueOf(reply.getObjectValue().getObjectID()) : null;
    }

    @Override
    public String callFunctionOnObject(String using, int objectId) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        EsdbgProtos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        return reply.getType().equals("null") ? null : reply.getValue();
    }

    @Override
    public Object callFunctionOnObject(String using, int objectId, boolean responseExpected) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        UmsProtos.Response response = this.eval(using, variable);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(response)) : null;
    }

    @Override
    public Integer executeScriptOnObject(String using, int objectId) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        EsdbgProtos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        Object object = this.parseEvalReply(reply);
        if (object == null || !(object instanceof EsdbgProtos.ObjectValue)) {
            return null;
        }
        return ((EsdbgProtos.ObjectValue)object).getObjectID();
    }

    protected Object parseEvalReply(EsdbgProtos.EvalResult result) {
        String dataType;
        String status = result.getStatus();
        if (!status.equals("completed")) {
            if (status.equals("unhandled-exception")) {
                throw new WebDriverException("Ecmascript exception");
            }
            if (status.equals("cancelled-by-scheduler")) {
                return null;
            }
            if (status.equals("aborted")) {
                // empty if block
            }
        }
        if ((dataType = result.getType()).equals("object")) {
            return result.getObjectValue();
        }
        return this.parseValue(dataType, result.getValue());
    }

    protected Object parseValue(String dataType, String value) {
        if (dataType.equals("string")) {
            return value;
        }
        if (dataType.equals("number")) {
            return this.parseNumber(value);
        }
        if (dataType.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (dataType.equals("undefined")) {
            return null;
        }
        return null;
    }

    protected EsdbgProtos.RuntimeInfo findRuntime() {
        return this.findRuntime(this.windowManager.getActiveWindowId());
    }

    protected EsdbgProtos.RuntimeInfo findRuntime(int windowId) {
        this.createAllRuntimes();
        EsdbgProtos.RuntimeInfo runtime = (EsdbgProtos.RuntimeInfo)this.xpathPointer(this.runtimesList.values(), "/.[htmlFramePath='" + this.currentFramePath + "' and windowID='" + windowId + "']").getValue();
        return runtime;
    }

    private void buildRuntimeTree() {
        this.updateRuntime();
        EsdbgProtos.RuntimeInfo rootInfo = this.findRuntime();
        String rootPath = rootInfo.getHtmlFramePath();
        this.root = new RuntimeNode();
        this.root.setFrameName(rootPath);
        this.root.setRuntimeID(rootInfo.getRuntimeID());
        ArrayList runtimesInfos = new ArrayList(this.runtimesList.values());
        runtimesInfos.remove(rootInfo);
        for (EsdbgProtos.RuntimeInfo runtimeInfo : runtimesInfos) {
            if (!runtimeInfo.getHtmlFramePath().startsWith(rootPath)) continue;
            this.addNode(runtimeInfo, this.root);
        }
    }

    @Override
    public void changeRuntime(int index) {
        this.buildRuntimeTree();
        RuntimeNode node = this.root.getNodes().get(index + 1);
        if (node == null) {
            throw new NoSuchFrameException("Invalid frame index " + index);
        }
        EsdbgProtos.RuntimeInfo info = (EsdbgProtos.RuntimeInfo)this.runtimesList.get(node.getRuntimeID());
        this.currentFramePath = info.getHtmlFramePath();
        this.setRuntime(info);
    }

    @Override
    public void changeRuntime(String frameName) {
        this.buildRuntimeTree();
        RuntimeNode curr = this.root;
        curr = this.findNodeByName(frameName, curr);
        if (curr == null) {
            throw new NoSuchFrameException("Invalid frame name " + frameName);
        }
        EsdbgProtos.RuntimeInfo info = (EsdbgProtos.RuntimeInfo)this.runtimesList.get(curr.getRuntimeID());
        if (!info.getHtmlFramePath().startsWith(this.currentFramePath)) {
            throw new NoSuchFrameException("No such frame " + frameName + " in " + this.currentFramePath);
        }
        this.currentFramePath = info.getHtmlFramePath();
        this.setRuntime(info);
    }

    private RuntimeNode findNodeByName(String name, RuntimeNode rootNode) {
        for (Map.Entry<Integer, RuntimeNode> entry : rootNode.getNodes().entrySet()) {
            if (this.isNumber(name) && entry.getKey().equals(Integer.valueOf(name) + 1)) {
                return entry.getValue();
            }
            if (entry.getValue().getFrameName().equals(name)) {
                return entry.getValue();
            }
            try {
                if (!this.executeScript("frameElement ? frameElement.id : ''", true, entry.getValue().getRuntimeID()).equals(name)) continue;
                return entry.getValue();
            }
            catch (WebDriverException e) {
            }
        }
        return null;
    }

    private void addNode(EsdbgProtos.RuntimeInfo info, RuntimeNode root) {
        String relFramePath = info.getHtmlFramePath().replace(root.getFrameName() + "/", "");
        String[] values = relFramePath.split("/");
        RuntimeNode curr = root;
        for (int i = 0; i < values.length; ++i) {
            int index = this.framePathToIndex(values[i]);
            if (curr.getNodes().get(index) == null) {
                RuntimeNode node = new RuntimeNode();
                int end = values[i].indexOf(91);
                node.setFrameName(values[i].substring(0, end));
                curr.getNodes().put(index, node);
                curr = node;
                continue;
            }
            curr = curr.getNodes().get(index);
        }
        curr.setRuntimeID(info.getRuntimeID());
    }

    private int framePathToIndex(String framePath) {
        int begin = framePath.indexOf(91);
        int end = framePath.indexOf(93);
        return Integer.valueOf(framePath.substring(begin + 1, end));
    }

    @Override
    public void cleanUpRuntimes(int windowId) {
        for (EsdbgProtos.RuntimeInfo runtime : this.runtimesList.values()) {
            if (runtime.getWindowID() != windowId) continue;
            this.runtimesList.remove(runtime.getRuntimeID());
        }
    }

    @Override
    public List<Integer> examineObjects(Integer id) {
        EsdbgProtos.ObjectList list = this.getObjectList(id);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<EsdbgProtos.ObjectInfo.Property> properties = list.getObjectList(0).getPropertyListList();
        for (EsdbgProtos.ObjectInfo.Property property : properties) {
            if (!property.getType().equals("object")) continue;
            ids.add(property.getObjectValue().getObjectID());
        }
        return ids;
    }

    @Override
    public List<String> listFramePaths() {
        List<EsdbgProtos.RuntimeInfo> runtimes = this.getRuntimesList();
        ArrayList<String> frameNames = new ArrayList<String>();
        for (EsdbgProtos.RuntimeInfo runtime : runtimes) {
            frameNames.add(runtime.getHtmlFramePath());
        }
        return frameNames;
    }

    @Override
    public void releaseObjects() {
        this.executeCommand(ESDebuggerCommand.RELEASE_OBJECTS, null);
    }

    @Override
    public void resetRuntimesList() {
        this.runtimesList.clear();
    }

    @Override
    public void readyStateChanged(EcmascriptProtos.ReadyStateChange change) {
    }

    @Override
    public void releaseObject(int objectId) {
    }

    @Override
    public void resetFramePath() {
        this.currentFramePath = "_top";
        this.setRuntime(this.findRuntime());
    }

    @Override
    public String executeJavascript(String using, Integer windowId) {
        String tmp = this.currentFramePath;
        this.currentFramePath = "_top";
        EsdbgProtos.RuntimeInfo runtime = this.findRuntime(windowId);
        this.currentFramePath = tmp;
        if (runtime == null) {
            return "";
        }
        return (String)this.executeScript(using, true, runtime.getRuntimeID());
    }

    @Override
    public Object examineScriptResult(Integer id) {
        EsdbgProtos.ObjectList list = this.getObjectList(id);
        String className = list.getObjectList(0).getValue().getName();
        List<EsdbgProtos.ObjectInfo.Property> properties = list.getObjectList(0).getPropertyListList();
        if (className.endsWith("Element")) {
            return new OperaWebElement(this.driver, id);
        }
        if (className.equals("Array")) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (EsdbgProtos.ObjectInfo.Property property : properties) {
                if (property.getType().equals("number") && property.getName().equals("length")) continue;
                if (property.getType().equals("object")) {
                    result.add(this.examineScriptResult(property.getObjectValue().getObjectID()));
                    continue;
                }
                result.add(this.parseValue(property.getType(), property.getValue()));
            }
            return result;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EsdbgProtos.ObjectInfo.Property property : properties) {
            if (property.getType().equals("number") && property.getName().equals("length")) continue;
            if (property.getType().equals("object")) {
                result.put(property.getName(), this.examineScriptResult(property.getObjectValue().getObjectID()));
                continue;
            }
            result.put(property.getName(), this.parseValue(property.getType(), property.getValue()));
        }
        return result;
    }

    private EsdbgProtos.ObjectList getObjectList(Integer id) {
        EsdbgProtos.ExamineList.Builder examine = EsdbgProtos.ExamineList.newBuilder();
        examine.setRuntimeID(this.getRuntimeId());
        examine.addObjectList(id);
        UmsProtos.Response response = this.executeCommand(ESDebuggerCommand.EXAMINE_OBJECTS, (AbstractMessage.Builder<?>)examine);
        EsdbgProtos.ObjectList.Builder builder = EsdbgProtos.ObjectList.newBuilder();
        EcmaScriptDebugger.buildPayload(response, builder);
        return builder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuntimeNode {
        private String frameName;
        private int runtimeID;
        private Map<Integer, RuntimeNode> nodes = new HashMap<Integer, RuntimeNode>();

        private RuntimeNode() {
        }

        public String getFrameName() {
            return this.frameName;
        }

        public void setFrameName(String frameName) {
            this.frameName = frameName;
        }

        public int getRuntimeID() {
            return this.runtimeID;
        }

        public void setRuntimeID(int runtimeID) {
            this.runtimeID = runtimeID;
        }

        public Map<Integer, RuntimeNode> getNodes() {
            return this.nodes;
        }
    }
}

