/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp;

import com.opera.core.systems.scope.handlers.AbstractEventHandler;
import com.opera.core.systems.scope.handlers.IConnectionHandler;
import com.opera.core.systems.scope.stp.StpConnectionListener;
import com.opera.core.systems.util.SocketMonitor;
import java.io.IOException;
import java.util.logging.Logger;

public class StpThread
extends Thread {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private StpConnectionListener listener;
    private volatile boolean cancelled;
    private SocketMonitor monitor = new SocketMonitor();

    public StpThread(int port, IConnectionHandler handler, AbstractEventHandler eventHandler, boolean manualConnect) throws IOException {
        this.listener = new StpConnectionListener(port, handler, eventHandler, manualConnect, this.monitor);
        this.setName("stp-thread");
    }

    public void shutdown() {
        this.cancelled = true;
        this.listener.stop();
        this.monitor.stop();
    }

    public void run() {
        this.logger.finer("Started StpThread");
        while (!this.cancelled) {
            this.monitor.poll(60000L);
        }
        this.logger.finer("Stopping StpThread");
    }
}

