/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opera.core.systems.OperaSeverity;
import com.opera.core.systems.scope.internal.ServiceCallback;
import com.opera.core.systems.scope.protos.ConsoleLoggerProtos;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;

public class OperaLogs
implements Logs {
    private final Map<String, List<LogEntry>> localLogs = Maps.newHashMap();
    private final Set<String> logTypesToIgnore;

    public OperaLogs() {
        this(new HashSet<String>());
    }

    public OperaLogs(Set<String> logTypesToIgnore) {
        this.logTypesToIgnore = logTypesToIgnore;
    }

    public LogEntries get(String logType) {
        Iterable<LogEntry> toReturn = this.getLocalLogs(logType);
        this.localLogs.remove(logType);
        return new LogEntries(toReturn);
    }

    private Iterable<LogEntry> getLocalLogs(String logType) {
        if (this.localLogs.containsKey(logType)) {
            return this.localLogs.get(logType);
        }
        return Lists.newArrayList();
    }

    public void addEntry(String logType, LogEntry entry) {
        if (this.logTypesToIgnore.contains(logType)) {
            return;
        }
        if (!this.localLogs.containsKey(logType)) {
            this.localLogs.put(logType, Lists.newArrayList((Object[])new LogEntry[]{entry}));
        } else {
            this.localLogs.get(logType).add(entry);
        }
    }

    public Set<String> getAvailableLogTypes() {
        return this.localLogs.keySet();
    }

    public static class DriverLogsHandler
    extends Handler {
        private final OperaLogs logs;

        public DriverLogsHandler(OperaLogs logs) {
            this.logs = logs;
        }

        @Override
        public void publish(LogRecord record) {
            LogEntry entry = new LogEntry(record.getLevel(), System.currentTimeMillis(), record.getMessage());
            this.logs.addEntry("driver", entry);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    public static class ConsoleMessageConverter
    implements ServiceCallback<ConsoleLoggerProtos.ConsoleMessage> {
        private final OperaLogs logs;

        public ConsoleMessageConverter(OperaLogs logs) {
            this.logs = logs;
        }

        @Override
        public void call(ConsoleLoggerProtos.ConsoleMessage message) {
            LogEntry entry = new LogEntry(OperaSeverity.get(message.getSeverity()).toLevel(), (long)message.getTime(), message.getDescription());
            this.logs.addEntry(message.getSource(), entry);
        }
    }
}

