/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock;

import com.oracle.bedrock.annotations.Internal;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

@Internal
public final class Bedrock {
    private static String version;

    private static String getArtifactFromPom(Path path) {
        String version;
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            doc.getDocumentElement().normalize();
            version = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
            if (version != null) {
                version = (version = version.trim()).isEmpty() ? null : version;
            }
        }
        catch (Exception e) {
            version = null;
        }
        return version;
    }

    public static String getVersion() {
        return version;
    }

    static {
        Package p;
        Class<Bedrock> versionClass = Bedrock.class;
        try {
            String className = versionClass.getName();
            String classfileName = "/" + className.replace('.', '/') + ".class";
            URL classfileResource = versionClass.getResource(classfileName);
            if (classfileResource != null) {
                Path absolutePackagePath = Paths.get(classfileResource.toURI()).getParent();
                int packagePathSegments = className.length() - className.replace(".", "").length();
                Path path = absolutePackagePath;
                int segmentsToRemove = packagePathSegments + 2;
                for (int i = 0; i < segmentsToRemove; ++i) {
                    path = path.getParent();
                }
                Path pom = path.resolve("pom.xml");
                version = Bedrock.getArtifactFromPom(pom);
                if (version == null) {
                    path = path.getParent();
                    version = Bedrock.getArtifactFromPom(path.resolve("pom.xml"));
                }
            }
        }
        catch (Exception e) {
            version = null;
        }
        try {
            Properties properties = new Properties();
            InputStream inputStream = Bedrock.class.getResourceAsStream("/META-INF/maven/com.oracle.bedrock/bedrock-core/pom.properties");
            if (inputStream != null) {
                properties.load(inputStream);
                version = properties.getProperty("version", null);
            }
        }
        catch (Exception e) {
            version = null;
        }
        if (version == null && (p = Bedrock.class.getPackage()) != null && (version = p.getImplementationVersion()) == null) {
            version = p.getSpecificationVersion();
        }
        if (version == null) {
            version = "";
        }
    }
}

