/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.Options;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.Stack;

public interface OptionsByType {
    @SafeVarargs
    public static OptionsByType of(Option ... options) {
        return new Options(options);
    }

    public static OptionsByType of(OptionsByType optionsByType) {
        return new Options(optionsByType);
    }

    public static OptionsByType empty() {
        return new Options(new Option[0]);
    }

    public <T extends Option> T get(Class<T> var1, Object ... var2);

    public <T extends Option> Optional<T> optionally(Class<T> var1, Object ... var2);

    public <T extends Option, D extends T> T getOrDefault(Class<T> var1, D var2);

    public <T extends Option, D extends T> T getOrSetDefault(Class<T> var1, D var2);

    public boolean contains(Class<? extends Option> var1);

    public boolean contains(Option var1);

    public <O> Iterable<O> getInstancesOf(Class<O> var1);

    public Option[] asArray();

    public OptionsByType add(Option var1);

    public OptionsByType addIfAbsent(Option var1);

    public OptionsByType addAll(Option ... var1);

    public OptionsByType addAll(OptionsByType var1);

    public <T extends Option> boolean remove(Class<T> var1);

    public boolean remove(Option var1);

    public static Class<? extends Option> getClassOf(Option option) {
        return option == null ? null : OptionsByType.getClassOf(option.getClass());
    }

    public static Class<? extends Option> getClassOf(Class<?> classOfOption) {
        Stack hierarchy = new Stack();
        while (classOfOption != null) {
            hierarchy.push(classOfOption);
            for (Class<?> interfaceClass : classOfOption.getInterfaces()) {
                if (Option.class.equals(interfaceClass) || ComposableOption.class.equals(interfaceClass) || Option.Collector.class.equals(interfaceClass)) {
                    while (classOfOption != null && Modifier.isAbstract(classOfOption.getModifiers()) && !classOfOption.isInterface()) {
                        classOfOption = hierarchy.isEmpty() ? null : (Class)hierarchy.pop();
                    }
                    return classOfOption;
                }
                if (!Option.class.isAssignableFrom(interfaceClass)) continue;
                while (classOfOption != null && Modifier.isAbstract(classOfOption.getModifiers()) && !classOfOption.isInterface()) {
                    classOfOption = hierarchy.isEmpty() ? null : (Class)hierarchy.pop();
                }
                if (classOfOption == null) {
                    return null;
                }
                return interfaceClass;
            }
            classOfOption = classOfOption.getSuperclass();
        }
        return null;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.METHOD})
    public static @interface Default {
    }
}

