/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.deferred.UnavailableException;
import java.util.concurrent.atomic.AtomicReference;

public class Cached<T>
implements Deferred<T> {
    private Deferred<T> deferred;
    private volatile AtomicReference<T> object;

    public Cached(Deferred<T> deferred) {
        this.deferred = deferred;
        this.object = null;
    }

    public Deferred<T> getDeferred() {
        return this.deferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        if (this.object == null) {
            Cached cached = this;
            synchronized (cached) {
                if (this.object == null) {
                    try {
                        T deferred = this.deferred.get();
                        this.object = new AtomicReference<T>(deferred);
                    }
                    catch (UnavailableException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw new TemporarilyUnavailableException(this, (Throwable)e);
                    }
                }
            }
        }
        return this.object.get();
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferred.getDeferredClass();
    }

    public synchronized T release() {
        T object = this.object == null ? null : (T)this.object.get();
        this.object = null;
        return object;
    }

    public String toString() {
        return String.format("Cached{%s}", this.getDeferredClass());
    }
}

