/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import java.util.function.Function;

public class DeferredFunction<T, R>
implements Deferred<R> {
    private Deferred<T> deferred;
    private Function<T, R> function;

    public DeferredFunction(Deferred<T> deferred, Function<T, R> function) {
        this.deferred = deferred;
        this.function = function;
    }

    @Override
    public R get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            T value = this.deferred.get();
            return this.function.apply(value);
        }
        catch (TemporarilyUnavailableException e) {
            throw e;
        }
        catch (PermanentlyUnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
    }
}

