/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.deferred.Cached;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredCallable;
import com.oracle.bedrock.deferred.DeferredInvoke;
import com.oracle.bedrock.deferred.DeferredPredicate;
import com.oracle.bedrock.deferred.Ensured;
import com.oracle.bedrock.deferred.Existing;
import com.oracle.bedrock.deferred.Future;
import com.oracle.bedrock.deferred.atomic.DeferredAtomicBoolean;
import com.oracle.bedrock.deferred.atomic.DeferredAtomicInteger;
import com.oracle.bedrock.deferred.atomic.DeferredAtomicLong;
import com.oracle.bedrock.deferred.options.InitialDelay;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.util.Duration;
import com.oracle.bedrock.util.ExponentialIterator;
import com.oracle.bedrock.util.FibonacciIterator;
import com.oracle.bedrock.util.MappingIterator;
import com.oracle.bedrock.util.PerpetualIterator;
import com.oracle.bedrock.util.ProxyHelper;
import com.oracle.bedrock.util.RandomIterator;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class DeferredHelper {
    public static final String BEDROCK_DEFERRED_RETRY_STRATEGY = "bedrock.deferred.retry.strategy";
    public static final String BEDROCK_DEFERRED_RETRY_TIMEOUT = "bedrock.deferred.retry.timeout";
    public static final long BEDROCK_DEFERRED_RETRY_TIMEOUT_SECS = 60L;
    public static final String BEDROCK_DEFERRED_MAXIMUM_POLLING_TIME = "bedrock.deferred.maximum.polling.time";
    public static final long BEDROCK_DEFERRED_MAXIMUM_POLLING_TIME_MS = 1000L;
    private static final ThreadLocal<Deferred<?>> DEFERRED = new ThreadLocal();
    private static final Duration ENSURED_MAXIMUM_RETRY_DURATION;
    private static final Duration ENSURED_MAXIMUM_POLLING_DURATION;
    private static final Iterable<Duration> ENSURED_RETRY_DURATIONS;

    public static Deferred<Long> deferred(AtomicLong atomic) {
        return new DeferredAtomicLong(atomic);
    }

    public static Deferred<Integer> deferred(AtomicInteger atomic) {
        return new DeferredAtomicInteger(atomic);
    }

    public static Deferred<Boolean> deferred(AtomicBoolean atomic) {
        return new DeferredAtomicBoolean(atomic);
    }

    public static <T> Deferred<T> deferred(Callable<T> callable, Class<T> callableReturnType) {
        return new DeferredCallable<T>(callable, callableReturnType);
    }

    public static Iterator<Duration> getDefaultEnsuredRetryDurations() {
        return ENSURED_RETRY_DURATIONS.iterator();
    }

    public static Iterable<Duration> getDefaultEnsuredRetryDurationsIterable() {
        return ENSURED_RETRY_DURATIONS;
    }

    public static Duration getDefaultEnsuredMaximumRetryDuration() {
        return ENSURED_MAXIMUM_RETRY_DURATION;
    }

    public static long getDefaultEnsuredTimeoutMS() {
        String duration = System.getProperty(BEDROCK_DEFERRED_RETRY_TIMEOUT);
        if (duration == null) {
            return TimeUnit.SECONDS.toMillis(60L);
        }
        Timeout timeout = Timeout.after(duration);
        return timeout.to(TimeUnit.MILLISECONDS);
    }

    public static Duration getDefaultEnsuredMaximumPollingDuration() {
        return ENSURED_MAXIMUM_POLLING_DURATION;
    }

    public static <T> Deferred<T> ensured(Deferred<T> deferred) {
        return deferred instanceof Ensured ? deferred : new Ensured(deferred, new Option[0]);
    }

    public static <T> Deferred<T> ensured(Deferred<T> deferred, Option ... options) {
        return deferred instanceof Ensured ? deferred : new Ensured(deferred, options);
    }

    public static <T> T ensure(T value) {
        return value;
    }

    public static <T> T ensure(Deferred<T> deferred) {
        return DeferredHelper.ensured(deferred).get();
    }

    public static <T> T ensure(Deferred<T> deferred, Option ... options) {
        return DeferredHelper.ensured(deferred, options).get();
    }

    public static <T> boolean ensure(Deferred<T> deferred, Predicate<? super T> predicate) {
        return DeferredHelper.ensure(deferred, predicate, new Option[0]);
    }

    public static <T> boolean ensure(Deferred<T> deferred, Predicate<? super T> predicate, Option ... options) {
        return DeferredHelper.ensure(new DeferredPredicate<T>(deferred, predicate), options);
    }

    public static <T> Cached<T> cached(Deferred<T> deferred) {
        return deferred instanceof Cached ? (Cached)deferred : new Cached<T>(deferred);
    }

    public static <T> Deferred<T> future(Class<T> clzOfResult, java.util.concurrent.Future<T> future) {
        return new Future<T>(clzOfResult, future);
    }

    public static <T> T invoking(T object) {
        return DeferredHelper.invoking(new Existing<T>(object));
    }

    public static <T, O> T invoking(O object, Class<T> specificClass) {
        return DeferredHelper.invoking(new Existing<T>(object, specificClass));
    }

    public static <T> T invoking(Deferred<T> deferred) {
        if (DEFERRED.get() == null) {
            T proxy = ProxyHelper.createProxyOf(deferred.getDeferredClass(), new DeferredMethodInterceptor());
            DEFERRED.set(deferred);
            return proxy;
        }
        throw new UnsupportedOperationException("An attempt was made to call 'invoking' without being wrapped inside an 'eventually' call. Alternatively two or more calls to 'invoking' have been made sequentially. Calls to 'invoking' must be contained inside an 'eventually' call.");
    }

    public static <T> T valueOf(Deferred<T> deferred) {
        if (DEFERRED.get() == null) {
            DEFERRED.set(deferred);
            return null;
        }
        throw new UnsupportedOperationException("An attempt was made to call 'valueOf' without being wrapped inside of an 'eventually' call. Alternatively two or more calls to 'valueOf' have been made sequentially. Calls to 'valueOf' must be contained inside an 'eventually' call.");
    }

    public static <T> T valueOf(Callable<T> callable, Class<T> returnType) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(callable, returnType));
    }

    public static Integer valueOf(AtomicInteger atomic) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(atomic));
    }

    public static Long valueOf(AtomicLong atomic) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(atomic));
    }

    public static Boolean valueOf(AtomicBoolean atomic) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(atomic));
    }

    public static <T> T valueOf(Callable<T> callable) {
        return (T)DeferredHelper.valueOf(DeferredHelper.deferred(callable, Object.class));
    }

    public static <T> Deferred<T> eventually(T t) {
        Deferred deferred = DEFERRED.get();
        if (deferred == null) {
            deferred = t instanceof Deferred ? (Deferred)t : new Existing<T>(t);
        } else {
            DEFERRED.set(null);
        }
        return deferred;
    }

    public static <T> Deferred<T> eventually(Deferred<T> t) {
        Deferred<Object> deferred = DEFERRED.get();
        if (deferred == null) {
            deferred = t;
        } else {
            DEFERRED.set(null);
        }
        return deferred;
    }

    public static Timeout within(long duration, TimeUnit units) {
        return Timeout.after(duration, units);
    }

    public static Timeout within(Timeout timeout) {
        return timeout;
    }

    public static InitialDelay delayedBy(long duration, TimeUnit units) {
        return InitialDelay.of(duration, units);
    }

    static {
        String maximumRetryDuration = System.getProperty(BEDROCK_DEFERRED_RETRY_TIMEOUT, Long.toString(60L) + "s");
        ENSURED_MAXIMUM_RETRY_DURATION = Duration.of(maximumRetryDuration);
        String maximumPollingDuration = System.getProperty(BEDROCK_DEFERRED_MAXIMUM_POLLING_TIME, Long.toString(1000L));
        ENSURED_MAXIMUM_POLLING_DURATION = Duration.of(maximumPollingDuration);
        String strategy = System.getProperty(BEDROCK_DEFERRED_RETRY_STRATEGY, "random.fibonacci");
        strategy = strategy.trim().toLowerCase();
        final MappingIterator.Function<Long, Duration> MILLISECONDS_TO_DURATION = new MappingIterator.Function<Long, Duration>(){

            @Override
            public Duration map(Long milliseconds) {
                return Duration.of(milliseconds, TimeUnit.MILLISECONDS);
            }
        };
        ENSURED_RETRY_DURATIONS = strategy.equals("random.fibonacci") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new RandomIterator(new FibonacciIterator()), MILLISECONDS_TO_DURATION);
            }
        } : (strategy.equals("random.exponential") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new RandomIterator(new ExponentialIterator(0.0, 50.0)), MILLISECONDS_TO_DURATION);
            }
        } : (strategy.equals("fibonacci") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new FibonacciIterator(), MILLISECONDS_TO_DURATION);
            }
        } : (strategy.equals("exponential") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new ExponentialIterator(0.0, 50.0), MILLISECONDS_TO_DURATION);
            }
        } : new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new PerpetualIterator<Duration>(Duration.of(250L, TimeUnit.MILLISECONDS));
            }
        })));
    }

    public static class DeferredMethodInterceptor
    implements ProxyHelper.Interceptor {
        @Override
        public Object intercept(Method method, Object[] args) throws Throwable {
            Deferred<?> deferred = DEFERRED.get();
            DEFERRED.set(new DeferredInvoke(deferred, method, args));
            Class<?> resultType = method.getReturnType();
            if (resultType.equals(Byte.class) || resultType.equals(Byte.TYPE)) {
                return new Byte(0);
            }
            if (resultType.equals(Short.class) || resultType.equals(Short.TYPE)) {
                return new Short(0);
            }
            if (resultType.equals(Integer.class) || resultType.equals(Integer.TYPE)) {
                return new Integer(0);
            }
            if (resultType.equals(Long.class) || resultType.equals(Long.TYPE)) {
                return new Long(0L);
            }
            if (resultType.equals(Float.class) || resultType.equals(Float.TYPE)) {
                return new Float(0.0);
            }
            if (resultType.equals(Double.class) || resultType.equals(Double.TYPE)) {
                return new Double(0.0);
            }
            if (resultType.equals(Character.class) || resultType.equals(Character.TYPE)) {
                return new Character(' ');
            }
            if (resultType.equals(Boolean.class) || resultType.equals(Boolean.TYPE)) {
                return new Boolean(false);
            }
            if (resultType.equals(AtomicBoolean.class)) {
                return new AtomicBoolean(false);
            }
            if (resultType.equals(AtomicInteger.class)) {
                return new AtomicInteger(0);
            }
            if (resultType.equals(AtomicLong.class)) {
                return new AtomicLong(0L);
            }
            if (resultType.isEnum()) {
                return null;
            }
            if (resultType.isArray()) {
                return Array.newInstance(resultType.getComponentType(), 0);
            }
            if (resultType.equals(String.class)) {
                return "";
            }
            return ProxyHelper.createProxyOf(resultType, new DeferredMethodInterceptor());
        }
    }
}

