/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.Existing;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DeferredInvoke<T>
implements Deferred<T> {
    private Deferred<?> deferred;
    private Method method;
    private Object[] arguments;

    public DeferredInvoke(Deferred<?> deferred, Method method, Object ... arguments) {
        this.deferred = deferred;
        this.method = method;
        this.arguments = arguments;
    }

    public DeferredInvoke(Object object, Method method, Object ... arguments) {
        this(new Existing<Object>(object), method, arguments);
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        Object object = this.deferred.get();
        if (object == null) {
            throw new PermanentlyUnavailableException(this, (Throwable)new NullPointerException("The underlying deferred was null"));
        }
        try {
            return (T)this.invoke(this.method, object, this.arguments);
        }
        catch (IllegalAccessException e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.method.getReturnType();
    }

    protected Object invoke(Method method, Object object, Object ... args) throws InvocationTargetException, IllegalAccessException {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException ex) {
            Class<?>[] interfaces = object.getClass().getInterfaces();
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    Method interfaceMethod = interfaces[i].getMethod(methodName, paramTypes);
                    return interfaceMethod.invoke(object, args);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            throw ex;
        }
    }

    public String toString() {
        StringBuilder arguments = new StringBuilder();
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                arguments.append(", ");
            }
            arguments.append(this.arguments[i]);
        }
        return String.format("DeferredInvoke{%s.%s(%s)}", this.getDeferredClass(), this.method.getName(), arguments);
    }
}

