/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.util.Duration;
import java.util.concurrent.TimeUnit;

public class InitialDelay
implements Option {
    private Duration duration;

    private InitialDelay(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public long to(TimeUnit units) {
        return this.duration.to(units);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InitialDelay)) {
            return false;
        }
        InitialDelay timeout = (InitialDelay)other;
        return this.duration.equals(timeout.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    public String toString() {
        return "InitialDelay{" + String.valueOf(this.getDuration()) + "}";
    }

    @OptionsByType.Default
    public static InitialDelay none() {
        return new InitialDelay(Duration.ZERO);
    }

    public static InitialDelay of(long duration, TimeUnit units) {
        return new InitialDelay(Duration.of(duration, units));
    }

    public static InitialDelay of(String duration) {
        return new InitialDelay(Duration.of(duration));
    }
}

