/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.util.Duration;
import java.util.concurrent.TimeUnit;

public class MaximumRetryDelay
implements Option {
    private Duration duration;

    private MaximumRetryDelay(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public long to(TimeUnit units) {
        return this.duration.to(units);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaximumRetryDelay)) {
            return false;
        }
        MaximumRetryDelay timeout = (MaximumRetryDelay)other;
        return this.duration.equals(timeout.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    public String toString() {
        return "MaximumRetryDelay{" + String.valueOf(this.getDuration()) + "}";
    }

    @OptionsByType.Default
    public static MaximumRetryDelay standard() {
        return new MaximumRetryDelay(Duration.of(1L, TimeUnit.SECONDS));
    }

    public static MaximumRetryDelay of(Duration duration) {
        return new MaximumRetryDelay(duration);
    }

    public static MaximumRetryDelay of(long duration, TimeUnit units) {
        return new MaximumRetryDelay(Duration.of(duration, units));
    }

    public static MaximumRetryDelay of(String duration) {
        return new MaximumRetryDelay(Duration.of(duration));
    }
}

