/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.lang;

import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.options.Variable;
import com.oracle.bedrock.options.Variables;
import jakarta.el.ELContext;
import jakarta.el.ELProcessor;
import jakarta.el.StandardELContext;
import java.util.HashMap;
import java.util.regex.Pattern;

@Internal
public class ExpressionEvaluator {
    private ELProcessor processor = new ELProcessor();

    public ExpressionEvaluator() {
        this(new Variables());
    }

    public ExpressionEvaluator(OptionsByType optionsByType) {
        this(optionsByType.get(Variables.class, new Object[0]));
    }

    public ExpressionEvaluator(Variable ... variables) {
        this(new Variables(variables));
    }

    public ExpressionEvaluator(Variables variables) {
        for (Variable variable : variables) {
            this.defineVariable(variable);
        }
    }

    public void defineVariable(String name, Object value) {
        this.defineVariable(Variable.with(name, value));
    }

    public void defineVariable(Variable variable) {
        if (variable.getName().contains(".")) {
            String[] partNames = variable.getName().split(Pattern.quote("."));
            HashMap<String, Object> lastMap = null;
            for (int i = 0; i < partNames.length; ++i) {
                boolean isLastPartName;
                String partName = partNames[i];
                boolean bl = isLastPartName = i == partNames.length - 1;
                if (lastMap == null) {
                    StandardELContext context = this.processor.getELManager().getELContext();
                    Object part = context.getELResolver().getValue((ELContext)context, null, (Object)partName);
                    if (part == null) {
                        lastMap = new HashMap<String, Object>();
                        this.processor.defineBean(partName, lastMap);
                        continue;
                    }
                    lastMap = (HashMap)part;
                    continue;
                }
                Object part = lastMap.get(partName);
                if (part == null) {
                    if (isLastPartName) {
                        lastMap.put(partName, variable.getValue());
                        continue;
                    }
                    HashMap nextMap = new HashMap();
                    lastMap.put(partName, nextMap);
                    lastMap = nextMap;
                    continue;
                }
                lastMap = (HashMap)part;
            }
        } else {
            this.processor.defineBean(variable.getName(), variable.getValue());
        }
    }

    public <T> T evaluate(String expression, Class<T> asClass) {
        Object result = null;
        boolean isCompositeExpression = false;
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < expression.length(); ++index) {
            if (expression.startsWith("\\$\\{", index)) {
                builder.append("${");
                ++index;
                isCompositeExpression = true;
                continue;
            }
            if (expression.startsWith("\\}", index)) {
                builder.append("}");
                ++index;
                isCompositeExpression = true;
                continue;
            }
            if (expression.startsWith("${", index)) {
                int indexEndSubExpression = expression.indexOf("}", index + 1);
                if (indexEndSubExpression <= index + 2) {
                    throw new IllegalArgumentException(String.format("Invalid expression definition in [%s].  Missing closing brace '}'.", expression));
                }
                String subExpression = expression.substring(index + 2, indexEndSubExpression).trim();
                index = indexEndSubExpression;
                result = this.processor.eval(subExpression);
                if (index < expression.length() - 1) {
                    isCompositeExpression = true;
                }
                if (!isCompositeExpression && !(result instanceof String)) continue;
                try {
                    builder.append(result.toString());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            builder.append(expression.charAt(index));
            isCompositeExpression = true;
        }
        Object object = result = isCompositeExpression ? builder.toString() : result;
        if (asClass.equals(String.class)) {
            return (T)(result == null ? "null" : result.toString());
        }
        return asClass.cast(result);
    }
}

