/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.util.Duration;
import java.util.concurrent.TimeUnit;

public class Timeout
implements Option {
    private Duration duration;

    private Timeout(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public long to(TimeUnit units) {
        return this.duration.to(units);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Timeout)) {
            return false;
        }
        Timeout timeout = (Timeout)other;
        return this.duration.equals(timeout.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    public String toString() {
        return "Timeout{" + String.valueOf(this.getDuration()) + "}";
    }

    @OptionsByType.Default
    public static Timeout autoDetect() {
        return new Timeout(Duration.of(1L, TimeUnit.MINUTES));
    }

    public static Timeout after(long duration, TimeUnit units) {
        return new Timeout(Duration.of(duration, units));
    }

    public static Timeout after(Duration duration) {
        return new Timeout(duration);
    }

    public static Timeout after(String duration) {
        return new Timeout(Duration.of(duration));
    }

    public static Timeout of(long duration, TimeUnit units) {
        return Timeout.after(duration, units);
    }

    public static Timeout of(Duration duration) {
        return Timeout.after(duration);
    }

    public static Timeout of(String duration) {
        return Timeout.after(duration);
    }
}

