/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Variable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class Variables
implements Option.Collector<Variable, Variables> {
    private LinkedHashMap<String, Variable> variables = new LinkedHashMap();

    @OptionsByType.Default
    public Variables() {
    }

    public Variables(Map<String, String> variables) {
        this();
        for (String name : variables.keySet()) {
            this.variables.put(name, Variable.with(name, variables.get(name)));
        }
    }

    public Variables(Properties properties) {
        this();
        for (String key : properties.stringPropertyNames()) {
            this.variables.put(key, Variable.with(key, properties.getProperty(key)));
        }
    }

    public Variables(Variable ... variables) {
        this();
        if (variables != null) {
            for (Variable property : variables) {
                this.add(property);
            }
        }
    }

    public Variables(Variables variables) {
        this();
        this.variables.putAll(variables.variables);
    }

    public int size() {
        return this.variables.size();
    }

    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    public Variables add(Variable variable) {
        if (variable == null) {
            return this;
        }
        Variables result = new Variables(this);
        result.variables.put(variable.getName(), variable);
        return result;
    }

    public Variables addIfAbsent(Variable variable) {
        if (variable == null || this.variables.containsKey(variable.getName())) {
            return this;
        }
        return this.add(variable);
    }

    public Variables remove(String name) {
        if (name == null || name.isEmpty() || !this.contains(name)) {
            return this;
        }
        Variables result = new Variables(this);
        result.variables.remove(name);
        return result;
    }

    public Variables addAll(Map<String, Object> properties) {
        Variables result = new Variables(this);
        for (String name : properties.keySet()) {
            result.variables.put(name, Variable.with(name, properties.get(name)));
        }
        return result;
    }

    public Variables addAll(Variables variables) {
        Variables result = new Variables(this);
        for (Variable variable : variables) {
            result.variables.put(variable.getName(), variable);
        }
        return result;
    }

    public boolean contains(String name) {
        return this.variables.containsKey(name);
    }

    public Variable get(String name) {
        return this.variables.get(name);
    }

    @Override
    public Variables with(Variable variable) {
        return this.add(variable);
    }

    @Override
    public Variables without(Variable variable) {
        return this.remove(variable.getName());
    }

    @Override
    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(Variable.class)) {
            return this.variables.values();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.variables.values().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variables)) {
            return false;
        }
        Variables that = (Variables)o;
        return this.variables.equals(that.variables);
    }

    public int hashCode() {
        return this.variables.hashCode();
    }
}

