/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.predicate;

import java.util.Arrays;
import java.util.function.Predicate;

public class AllOf<T>
implements Predicate<T> {
    private Predicate<? super T>[] predicates;

    public AllOf(Predicate<? super T> ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean test(T value) {
        if (this.predicates == null) {
            return false;
        }
        for (Predicate<T> predicate : this.predicates) {
            if (predicate.test(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "AllOf{" + Arrays.toString(this.predicates) + "}";
    }
}

