/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.table;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import java.util.ArrayList;

public class Cell {
    private ArrayList<String> lines = new ArrayList();
    private OptionsByType optionsByType = OptionsByType.empty();

    public Cell(String ... lines) {
        if (lines != null) {
            for (String content : lines) {
                if (content == null) {
                    this.lines.add(null);
                    continue;
                }
                for (String line : content.split("\\n\\r|\\n")) {
                    this.lines.add(line);
                }
            }
        }
    }

    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return null;
        }
        return this.lines.get(index);
    }

    public boolean isEmpty() {
        for (String line : this.lines) {
            if (line != null && (line.length() <= 0 || line.trim().isEmpty())) continue;
            return false;
        }
        return true;
    }

    public boolean containsNull() {
        for (String line : this.lines) {
            if (line != null) continue;
            return true;
        }
        return false;
    }

    public int height() {
        return this.lines.size();
    }

    public int width() {
        int maximum = 0;
        for (String line : this.lines) {
            if (line == null || line.length() <= maximum) continue;
            maximum = line.length();
        }
        return maximum;
    }

    public static class Width
    implements Option {
        private static Width AUTODETECT = new Width(-1);
        private int characters;

        private Width(int characters) {
            this.characters = characters;
        }

        public boolean isAutoDetect() {
            return this.characters < 0;
        }

        public int getCharacters() {
            return this.characters;
        }

        @OptionsByType.Default
        public static Width autodetect() {
            return AUTODETECT;
        }

        public static Width of(int characters) {
            return new Width(characters);
        }
    }

    public static class Separator
    implements Option {
        private static final Separator STANDARD = new Separator(":");
        private String separator;

        private Separator(String separator) {
            this.separator = separator;
        }

        public String getSeparator() {
            return this.separator;
        }

        public static Separator of(String separator) {
            return new Separator(separator);
        }

        @OptionsByType.Default
        public static Separator standard() {
            return STANDARD;
        }
    }

    public static class DisplayNull
    implements Option {
        private String value;

        private DisplayNull(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static DisplayNull as(String value) {
            return new DisplayNull(value);
        }

        @OptionsByType.Default
        public static DisplayNull asEmptyString() {
            return new DisplayNull("");
        }

        public static DisplayNull asNull() {
            return new DisplayNull("null");
        }
    }

    public static enum Justification implements Option
    {
        LEFT,
        RIGHT;


        public String format(String content, int width) {
            return width <= 0 ? "" : (this == LEFT ? String.format("%1$-" + width + "s", content) : String.format("%1$" + width + "s", content));
        }
    }
}

