/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.table;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.table.Cell;
import java.util.ArrayList;
import java.util.Iterator;

public class Row
implements Iterable<Cell> {
    private ArrayList<Cell> cells = new ArrayList();
    private OptionsByType optionsByType;

    public Row(Cell ... cells) {
        if (cells != null) {
            for (Cell cell : cells) {
                this.cells.add(cell);
            }
        }
        this.optionsByType = OptionsByType.empty();
    }

    public int width() {
        return this.cells.size();
    }

    public Row addCell(Cell cell) {
        this.cells.add(cell);
        return this;
    }

    public Row addCell(String cell) {
        return this.addCell(new Cell(cell));
    }

    public Cell getCell(int index) {
        if (index < 0 || index >= this.cells.size()) {
            return null;
        }
        return this.cells.get(index);
    }

    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cells.iterator();
    }

    public static interface Comparator
    extends Option,
    java.util.Comparator<Row> {
    }
}

