/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import java.util.Iterator;

public class ExponentialIterator
implements Iterator<Long> {
    private double initial;
    private double rate;
    private long iteration;

    public ExponentialIterator(double initial, double percentage) {
        this.initial = initial;
        this.rate = 1.0 + percentage / 100.0;
        this.iteration = 0L;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Long next() {
        long result = this.iteration == 0L ? Math.round(this.initial) : Math.round(this.initial + Math.pow(this.rate, this.iteration - 1L));
        ++this.iteration;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from a " + this.getClass().getName());
    }
}

