/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import com.oracle.bedrock.util.PerpetualIterator;
import java.util.Iterator;
import java.util.Random;

public class RandomIterator
implements Iterator<Long> {
    private Iterator<Long> ranges;
    private Random random;

    public RandomIterator(Iterator<Long> ranges) {
        this.ranges = ranges;
        this.random = new Random(System.nanoTime());
    }

    public RandomIterator(long range) {
        this(new PerpetualIterator<Long>(range));
    }

    @Override
    public boolean hasNext() {
        return this.ranges.hasNext();
    }

    @Override
    public Long next() {
        long range = this.ranges.next();
        long random = Math.abs(this.random.nextLong());
        return range == 0L ? 0L : random % range;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from a " + this.getClass().getName());
    }
}

