/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionHelper {
    public static <T> Constructor<T> getCompatibleConstructor(Class<T> clazz, Class<?> ... argumentTypes) {
        try {
            return clazz.getConstructor(argumentTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] formalParameterTypes = constructor.getParameterTypes();
                if (argumentTypes.length != formalParameterTypes.length) continue;
                boolean parametersMatch = true;
                for (int i = 0; i < argumentTypes.length && parametersMatch; ++i) {
                    Class<?> argumentType = argumentTypes[i];
                    Class<?> formalParameterType = formalParameterTypes[i];
                    parametersMatch = argumentType == null ? !formalParameterType.isPrimitive() : (argumentType.isPrimitive() ? ReflectionHelper.isAssignablePrimitive(argumentType, formalParameterType) : formalParameterType.isAssignableFrom(argumentType));
                }
                if (!parametersMatch) continue;
                return constructor;
            }
            return null;
        }
    }

    public static boolean isAssignablePrimitive(Class<?> clzPrimitive, Class<?> clzWrapper) {
        return clzPrimitive.equals(Boolean.TYPE) && clzWrapper.equals(Boolean.class) || clzPrimitive.equals(Byte.TYPE) && clzWrapper.equals(Byte.class) || clzPrimitive.equals(Character.TYPE) && clzWrapper.equals(Character.class) || clzPrimitive.equals(Double.TYPE) && clzWrapper.equals(Double.class) || clzPrimitive.equals(Float.TYPE) && clzWrapper.equals(Float.class) || clzPrimitive.equals(Integer.TYPE) && clzWrapper.equals(Integer.class) || clzPrimitive.equals(Long.TYPE) && clzWrapper.equals(Long.class) || clzPrimitive.equals(Short.TYPE) && clzWrapper.equals(Short.class);
    }

    public static Method getCompatibleMethod(Class<?> clazz, String methodName, Object ... actualArguments) {
        Class[] argumentTypes = new Class[actualArguments.length];
        for (int i = 0; i < actualArguments.length; ++i) {
            argumentTypes[i] = actualArguments[i] == null ? null : actualArguments[i].getClass();
        }
        try {
            return clazz.getMethod(methodName, argumentTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Method method : clazz.getMethods()) {
                Class<?>[] formalParameterTypes;
                if (!methodName.equals(method.getName()) || argumentTypes.length != (formalParameterTypes = method.getParameterTypes()).length) continue;
                boolean parametersMatch = true;
                for (int i = 0; i < argumentTypes.length && parametersMatch; ++i) {
                    Class argumentType = argumentTypes[i];
                    Class<?> formalParameterType = formalParameterTypes[i];
                    parametersMatch = argumentType == null ? !formalParameterType.isPrimitive() : (argumentType.isPrimitive() ? ReflectionHelper.isAssignablePrimitive(argumentType, formalParameterType) : (formalParameterType.isPrimitive() ? ReflectionHelper.isAssignablePrimitive(formalParameterType, argumentType) : formalParameterType.isAssignableFrom(argumentType)));
                }
                if (!parametersMatch) continue;
                return method;
            }
            return null;
        }
    }

    public static Object createObject(String className, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(className, true, classLoader);
        Constructor<?> con = clazz.getDeclaredConstructor(null);
        return con.newInstance(null);
    }

    public static Object createObject(String className, ClassLoader classLoader, Object ... constructorParameterList) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(className, true, classLoader);
        Class<?>[] parameterTypes = ReflectionHelper.getClassArrayFromObjectArray(constructorParameterList);
        Constructor<?> con = ReflectionHelper.getCompatibleConstructor(clazz, parameterTypes);
        return con.newInstance(constructorParameterList);
    }

    protected static Class<?>[] getClassArrayFromObjectArray(Object[] objectArray) {
        Class[] parameterTypes = null;
        if (objectArray != null) {
            parameterTypes = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                parameterTypes[i] = objectArray[i].getClass();
            }
        }
        return parameterTypes;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> onClass, Class<A> desiredAnnotationClass) {
        if (onClass == null || desiredAnnotationClass == null) {
            return null;
        }
        if (onClass.getClass().equals(Object.class)) {
            return null;
        }
        A annotation = onClass.getAnnotation(desiredAnnotationClass);
        if (annotation == null) {
            for (Class<?> onInterface : onClass.getInterfaces()) {
                annotation = ReflectionHelper.getAnnotation(onInterface, desiredAnnotationClass);
                if (annotation == null) continue;
                return annotation;
            }
            return ReflectionHelper.getAnnotation(onClass.getSuperclass(), desiredAnnotationClass);
        }
        return annotation;
    }
}

