/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RepetitiveIterator<T>
implements Iterator<T> {
    private T value;
    private int count;

    public RepetitiveIterator(T value, int count) {
        this.value = value;
        this.count = count;
    }

    @Override
    public boolean hasNext() {
        return this.count > 0;
    }

    @Override
    public T next() {
        if (this.count <= 0) {
            throw new NoSuchElementException("No values remain in the iteration");
        }
        --this.count;
        return this.value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("PerpetualIterator's don't support removing values");
    }
}

