/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.CoherenceBuilder;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.CacheConfig;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.net.Coherence;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.SessionConfiguration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCoherenceBuilder
implements CoherenceBuilder {
    private static final Logger LOGGER = Logger.getLogger(AbstractCoherenceBuilder.class.getName());

    @Override
    public Coherence build(LocalPlatform platform, CoherenceCluster cluster, OptionsByType optionsByType) {
        Coherence coherence;
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        optionsByType = OptionsByType.of((OptionsByType)optionsByType);
        optionsByType.add((Option)RoleName.of((String)"client"));
        optionsByType.add((Option)LocalStorage.disabled());
        optionsByType.addIfAbsent((Option)CacheConfig.of((String)"coherence-cache-config.xml"));
        CoherenceClusterMember.MetaClass metaClass = new CoherenceClusterMember.MetaClass();
        for (Profile profile : optionsByType.getInstancesOf(Profile.class)) {
            profile.onLaunching((Platform)platform, (MetaClass)metaClass, optionsByType);
        }
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        Properties properties = systemProperties.resolve((Platform)platform, optionsByType);
        Table systemPropertiesTable = new Table(new Row[0]);
        systemPropertiesTable.getOptions().add((Option)Table.orderByColumn((int)0));
        systemPropertiesTable.getOptions().add((Option)Cell.Separator.of((String)""));
        systemPropertiesTable.getOptions().add((Option)Cell.DisplayNull.asEmptyString());
        Coherence.Mode mode = this.getMode();
        SessionConfiguration.Builder sessionBuilder = SessionConfiguration.builder().withMode(mode).withConfigUri(((CacheConfig)optionsByType.get(CacheConfig.class, new Object[0])).getUri());
        for (String propertyName : properties.stringPropertyNames()) {
            String propertyValue = properties.getProperty(propertyName);
            systemPropertiesTable.addRow(new String[]{propertyName + (System.getProperties().containsKey(propertyName) ? "*" : ""), propertyValue});
            System.setProperty(propertyName, propertyValue.isEmpty() ? "" : propertyValue);
            sessionBuilder.withParameter(propertyName, (Object)(propertyValue.isEmpty() ? "" : propertyValue));
        }
        diagnosticsTable.addRow(new String[]{"System Properties", systemPropertiesTable.toString()});
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Storage Disabled Member...\n------------------------------------------------------------------------\n" + String.valueOf(diagnosticsTable) + "\n------------------------------------------------------------------------\n");
        }
        CoherenceConfiguration configuration = CoherenceConfiguration.builder().withSession(sessionBuilder.build()).build();
        Timeout timeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
        try {
            coherence = (Coherence)Coherence.builder((CoherenceConfiguration)configuration, (Coherence.Mode)mode).build().start().get(timeout.to(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)"Failed to start Coherence");
        }
        return coherence;
    }

    protected abstract Coherence.Mode getMode();

    public boolean equals(Object other) {
        return other instanceof AbstractCoherenceBuilder;
    }

    public int hashCode() {
        return AbstractCoherenceBuilder.class.hashCode();
    }
}

