/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.DeferredPredicate;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.options.Decoration;
import com.oracle.bedrock.options.Decorations;
import com.oracle.bedrock.runtime.AbstractAssembly;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.ServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.GetAutoStartServiceNames;
import com.oracle.bedrock.runtime.coherence.callables.GetServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.IsCoherenceRunning;
import com.oracle.bedrock.runtime.coherence.callables.IsReady;
import com.oracle.bedrock.runtime.coherence.callables.IsSafe;
import com.oracle.bedrock.runtime.coherence.callables.IsServiceStorageEnabled;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.options.Caching;
import com.oracle.bedrock.runtime.concurrent.runnable.ThreadDump;
import com.oracle.bedrock.runtime.options.StabilityPredicate;
import com.oracle.bedrock.util.Trilean;
import com.tangosol.net.NamedCache;
import com.tangosol.util.UID;
import com.tangosol.util.function.Remote;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class CoherenceCluster
extends AbstractAssembly<CoherenceClusterMember> {
    public CoherenceCluster(OptionsByType optionsByType) {
        super(optionsByType);
    }

    public boolean isReady() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CoherenceClusterMember member = (CoherenceClusterMember)iterator.next();
            if (((Boolean)member.invoke(IsReady.INSTANCE, new Option[0])).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isSafe() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CoherenceClusterMember member = (CoherenceClusterMember)iterator.next();
            if (((Boolean)member.invoke(IsSafe.INSTANCE, new Option[0])).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public int getClusterSize() {
        Iterator members = this.iterator();
        return members.hasNext() ? ((CoherenceClusterMember)members.next()).getClusterSize() : 0;
    }

    public Set<UID> getClusterMemberUIDs() {
        Iterator members = this.iterator();
        return members.hasNext() ? ((CoherenceClusterMember)members.next()).getClusterMemberUIDs() : Collections.emptySet();
    }

    public NamedCache getCache(String cacheName) {
        Iterator members = this.iterator();
        return members.hasNext() ? ((CoherenceClusterMember)members.next()).getCache(cacheName) : null;
    }

    public <K, V> NamedCache<K, V> getCache(String cacheName, Class<K> keyClass, Class<V> valueClass) {
        Iterator members = this.iterator();
        return members.hasNext() ? ((CoherenceClusterMember)members.next()).getCache(cacheName, keyClass, valueClass) : null;
    }

    protected void onRelaunching(CoherenceClusterMember member, OptionsByType optionsByType) {
        UID memberUID = member.getLocalMemberUID();
        optionsByType.add((Option)Decoration.of((Object)memberUID));
        this.onChanged(optionsByType);
    }

    protected void onRelaunched(CoherenceClusterMember original, CoherenceClusterMember restarted, OptionsByType optionsByType) {
        Decorations decorations = (Decorations)optionsByType.get(Decorations.class, new Object[0]);
        Option[] options = optionsByType.asArray();
        UID originalMemberUID = (UID)decorations.get(UID.class);
        if (originalMemberUID != null) {
            DeferredHelper.ensure((Deferred)DeferredHelper.eventually(((CoherenceCluster)((Object)DeferredHelper.invoking((Object)((Object)this)))).getClusterMemberUIDs()), (Predicate)com.oracle.bedrock.predicate.Predicates.doesNotContain((Object)originalMemberUID), (Option[])options);
        }
        DeferredHelper.ensure((Deferred)DeferredHelper.eventually((Object)((CoherenceClusterMember)DeferredHelper.invoking((Object)restarted)).getClusterSize()), (Predicate)com.oracle.bedrock.predicate.Predicates.greaterThan((Comparable)Integer.valueOf(1)), (Option[])options);
        UID restartedMemberUID = restarted.getLocalMemberUID();
        DeferredHelper.ensure((Deferred)DeferredHelper.eventually(((CoherenceCluster)((Object)DeferredHelper.invoking((Object)((Object)this)))).getClusterMemberUIDs()), (Predicate)com.oracle.bedrock.predicate.Predicates.contains((Object)restartedMemberUID), (Option[])options);
        this.onChanged(optionsByType);
    }

    protected void onChanged(OptionsByType options) {
        try {
            StabilityPredicate stabilityPredicate = (StabilityPredicate)options.getOrDefault(StabilityPredicate.class, null);
            if (stabilityPredicate != null) {
                DeferredPredicate deferredPredicate = new DeferredPredicate((Object)this, stabilityPredicate.get());
                DeferredHelper.ensure((Deferred)DeferredHelper.eventually((Deferred)deferredPredicate), (Predicate)com.oracle.bedrock.predicate.Predicates.is((Object)true), (Option[])options.asArray());
            }
        }
        catch (PermanentlyUnavailableException e) {
            CoherenceClusterMember[] aMember = (CoherenceClusterMember[])this.applications.toArray(CoherenceClusterMember[]::new);
            CompletableFuture[] aFuture = new CompletableFuture[aMember.length];
            for (int i = 0; i < aMember.length; ++i) {
                try {
                    aFuture[i] = aMember[i].submit((RemoteRunnable)ThreadDump.toStdErr(), new Option[0]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                CompletableFuture.allOf(aFuture).get(2L, TimeUnit.MINUTES);
            }
            catch (Exception ex) {
                System.err.println("Caught exception waiting for thread dumps to complete " + ex.getMessage());
            }
            throw e;
        }
    }

    static class IsCoherenceRunningPredicate
    implements Remote.Predicate<CoherenceCluster> {
        private final Set<String> f_setNames;

        public IsCoherenceRunningPredicate(Set<String> setNames) {
            this.f_setNames = setNames;
        }

        public boolean test(CoherenceCluster cluster) {
            Iterator iterator = cluster.iterator();
            while (iterator.hasNext()) {
                CoherenceClusterMember member = (CoherenceClusterMember)iterator.next();
                if (((Boolean)member.invoke(new IsCoherenceRunning(this.f_setNames), new Option[0])).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "IsCoherenceRunningPredicate(coherence=" + String.valueOf(this.f_setNames) + ")";
        }
    }

    static class IsReadyPredicate
    implements Remote.Predicate<CoherenceCluster> {
        static final IsReadyPredicate INSTANCE = new IsReadyPredicate();

        IsReadyPredicate() {
        }

        public boolean test(CoherenceCluster cluster) {
            Iterator iterator = cluster.iterator();
            while (iterator.hasNext()) {
                CoherenceClusterMember member = (CoherenceClusterMember)iterator.next();
                if (((Boolean)member.invoke(IsReady.INSTANCE, new Option[0])).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "IsReadyPredicate";
        }
    }

    static class IsAutoStartServicesSafePredicate
    implements Remote.Predicate<CoherenceCluster> {
        static final IsAutoStartServicesSafePredicate INSTANCE = new IsAutoStartServicesSafePredicate();

        IsAutoStartServicesSafePredicate() {
        }

        public boolean test(CoherenceCluster cluster) {
            Set serviceNames;
            CoherenceClusterMember member;
            HashMap<String, Integer> serviceCountMap = new HashMap<String, Integer>();
            Iterator iterator = cluster.iterator();
            while (iterator.hasNext()) {
                member = (CoherenceClusterMember)iterator.next();
                serviceNames = (Set)member.invoke(new GetAutoStartServiceNames(), new Option[]{Caching.enabled((Option[])new Option[0])});
                for (String serviceName : serviceNames) {
                    Trilean trilean = (Trilean)member.invoke(new IsServiceStorageEnabled(serviceName), new Option[]{Caching.enabled((Option[])new Option[0])});
                    int adjust = trilean == Trilean.FALSE ? 0 : 1;
                    serviceCountMap.compute(serviceName, (name, count) -> count == null ? adjust : count + adjust);
                }
            }
            iterator = cluster.iterator();
            while (iterator.hasNext()) {
                member = (CoherenceClusterMember)iterator.next();
                serviceNames = (Set)member.invoke(new GetAutoStartServiceNames(), new Option[]{Caching.enabled((Option[])new Option[0])});
                for (String serviceName : serviceNames) {
                    ServiceStatus status;
                    int count2 = (Integer)serviceCountMap.get(serviceName);
                    if (!(count2 > 1 ? (status = (ServiceStatus)((Object)member.invoke(new GetServiceStatus(serviceName), new Option[0]))) == null || status == ServiceStatus.ENDANGERED || status == ServiceStatus.ORPHANED || status == ServiceStatus.STOPPED || status == ServiceStatus.UNKNOWN : count2 == 1 && ((status = (ServiceStatus)((Object)member.invoke(new GetServiceStatus(serviceName), new Option[0]))) == null || status == ServiceStatus.STOPPED || status == ServiceStatus.UNKNOWN))) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "IsReadyPredicate";
        }
    }

    public static interface Predicates {
        public static Predicate<CoherenceCluster> autoStartServicesSafe() {
            return IsAutoStartServicesSafePredicate.INSTANCE;
        }

        public static Predicate<CoherenceCluster> isCoherenceRunning() {
            return new IsCoherenceRunningPredicate(Set.of(""));
        }

        public static Predicate<CoherenceCluster> isReady() {
            return IsReadyPredicate.INSTANCE;
        }

        public static Predicate<CoherenceCluster> isReady(String sHealthCheck) {
            return Predicates.isCoherenceRunning(Set.of(""));
        }

        public static Predicate<CoherenceCluster> isCoherenceRunning(String ... asName) {
            return Predicates.isCoherenceRunning(Set.of(asName));
        }

        public static Predicate<CoherenceCluster> isCoherenceRunning(Set<String> setName) {
            return new IsCoherenceRunningPredicate(setName);
        }
    }
}

