/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public enum JMXManagementMode implements Option,
Profile
{
    ALL,
    NONE,
    REMOTE_ONLY,
    LOCAL_ONLY;

    public static final String PROPERTY = "coherence.management";

    public String toSystemProperty() {
        String result = "all";
        if (this == NONE) {
            result = "none";
        } else if (this == REMOTE_ONLY) {
            result = "remote-only";
        } else if (this == LOCAL_ONLY) {
            result = "local-only";
        }
        return result;
    }

    public static JMXManagementMode fromSystemProperty(String systemProperty) {
        String string = systemProperty = systemProperty == null ? "" : systemProperty.trim().toLowerCase();
        if (systemProperty == null) {
            return null;
        }
        if (systemProperty.equals("none")) {
            return NONE;
        }
        if (systemProperty.equals("remote-only")) {
            return REMOTE_ONLY;
        }
        if (systemProperty.equals("local-only")) {
            return LOCAL_ONLY;
        }
        if (systemProperty.equals("all")) {
            return ALL;
        }
        return null;
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.toSystemProperty(), (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }
}

