/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.Coherence;
import com.tangosol.net.Session;

public class SessionExists
implements RemoteCallable<Boolean> {
    private final String m_sCoherenceName;
    private final String m_sSessionName;

    public SessionExists() {
        this("", "");
    }

    public SessionExists(String sSessionName) {
        this("", sSessionName);
    }

    public SessionExists(String sCoherenceName, String sSessionName) {
        this.m_sCoherenceName = sCoherenceName == null || sCoherenceName.isBlank() ? "" : sCoherenceName;
        this.m_sSessionName = sSessionName == null || sSessionName.isBlank() ? "" : sSessionName;
    }

    public Boolean call() throws Exception {
        Coherence coherence = Coherence.getInstance((String)this.m_sCoherenceName);
        if (coherence == null) {
            Logger.err((String)("In Bedrock SessionExists: No Coherence instance exists with name \"" + this.m_sCoherenceName + "\""));
            return false;
        }
        Session session = coherence.getSession(this.m_sSessionName);
        if (session == null) {
            Logger.err((String)("In Bedrock SessionExists: No Session instance exists with name \"" + this.m_sSessionName + "\" in Coherence instance \"" + this.m_sCoherenceName + "\""));
            return false;
        }
        return true;
    }
}

