/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class NTFJMSConnectionGroup
implements Monitor {
    ArrayList<NTFJMSConnection> jmsListenerConnections;
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId;
    private int noOfRegistrationsInThisGroup;
    String uniqueIdentifier;
    private final Monitor.CloseableLock monitorLock;
    static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS;
    private static final Monitor MAX_NTF_CONNECTIONS_MONITOR;
    private int aliveConnections;
    private HashMap<Long, NTFJMSRegistration> jmsRegIdToNtfReg;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    public static void setMaxNtfConnection(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int maxConn;
            Monitor.CloseableLock lock;
            block15: {
                block16: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, n2);
                    }
                    lock = MAX_NTF_CONNECTIONS_MONITOR.acquireCloseableLock();
                    try {
                        if (maxConn <= 0) {
                            maxConn = 16;
                        }
                        if (MAX_NTF_CONNECTIONS <= 0) break block15;
                        if (lock != null) {
                            lock.close();
                        }
                        if (!bl) break block16;
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        Throwable throwable3 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, throwable3);
                        }
                        throw throwable3;
                    }
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, null);
                }
                return;
            }
            MAX_NTF_CONNECTIONS = maxConn;
            if (lock != null) {
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, throwable4);
            }
            throw throwable;
        }
    }

    public static int getMaxNtfConnection() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, new Object[0]);
            }
            if (MAX_NTF_CONNECTIONS == 0) {
                int n2 = 16;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, null);
                }
                return 16;
            }
            int n3 = MAX_NTF_CONNECTIONS;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    NTFJMSConnectionGroup(String uniqueIdentifier) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$13, null, uniqueIdentifier);
            }
            this.jmsListenerConnections = new ArrayList();
            this.jmsRegIdToJDBCRegId = new HashMap();
            this.noOfRegistrationsInThisGroup = 0;
            this.monitorLock = this.newDefaultLock();
            this.aliveConnections = 0;
            this.jmsRegIdToNtfReg = new HashMap();
            this.uniqueIdentifier = uniqueIdentifier;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    void checkForActiveRegistrations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                if (this.noOfRegistrationsInThisGroup == 0) {
                    if (!this.jmsListenerConnections.isEmpty()) {
                        for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                            if (listenerConnection == null) continue;
                            listenerConnection.setNeedToBeClosed(true);
                            listenerConnection.interrupt();
                            listenerConnection.closeThisListener();
                            --this.aliveConnections;
                        }
                        this.jmsListenerConnections.clear();
                    }
                    PhysicalConnection.ntfManager.removeJMSConnectionGroup(this.uniqueIdentifier);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void startJMSListenerConnection(String string, String string2, String string3, OpaqueString opaqueString, ArrayList<String> arrayList, String string4, int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, string, string2, string3, opaqueString, arrayList, string4, n2);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void numberOfRegistrations;
                void password;
                void userName;
                void serviceName;
                void instanceName;
                void listenerAddresses;
                void jmsConnectionId;
                if (!$assertionsDisabled && jmsConnectionId == null) {
                    AssertionError assertionError = new AssertionError((Object)"jmsConnectionId is null");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                String connClass = "notify" + (String)jmsConnectionId;
                NTFJMSConnection jmsListenerConnection = new NTFJMSConnection((String)jmsConnectionId, (ArrayList<String>)listenerAddresses, (String)instanceName, (String)serviceName, (String)userName, (OpaqueString)password, connClass, (int)numberOfRegistrations);
                this.jmsListenerConnections.add(jmsListenerConnection);
                jmsListenerConnection.setDaemon(true);
                jmsListenerConnection.start();
                ++this.aliveConnections;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    void decrementNumberOfRegistrations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                --this.noOfRegistrationsInThisGroup;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFJMSConnection getNTFJMSConnection(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            NTFJMSConnection nTFJMSConnection;
            block16: {
                Monitor.CloseableLock lock;
                block14: {
                    NTFJMSConnection nTFJMSConnection2;
                    block15: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, n2);
                        }
                        lock = this.acquireCloseableLock();
                        try {
                            void numberOfNewRegistrations;
                            this.noOfRegistrationsInThisGroup += numberOfNewRegistrations;
                            if (this.noOfRegistrationsInThisGroup <= NTFJMSConnectionGroup.getMaxNtfConnection()) break block14;
                            int minimumRegistrations = this.noOfRegistrationsInThisGroup;
                            NTFJMSConnection connectionWithMinimumRegistrations = this.jmsListenerConnections.get(0);
                            for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                                int numberOfRegistrationsInConnection = listenerConnection.getNumberOfRegistrations();
                                if (numberOfRegistrationsInConnection >= minimumRegistrations) continue;
                                connectionWithMinimumRegistrations = listenerConnection;
                                minimumRegistrations = numberOfRegistrationsInConnection;
                            }
                            connectionWithMinimumRegistrations.incrementNumberOfRegistrations((int)numberOfNewRegistrations);
                            NTFJMSConnection nTFJMSConnection3 = connectionWithMinimumRegistrations;
                            if (lock != null) {
                                lock.close();
                            }
                            nTFJMSConnection2 = nTFJMSConnection3;
                            if (!bl) break block15;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, nTFJMSConnection2);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, null);
                    }
                    return nTFJMSConnection2;
                }
                NTFJMSConnection nTFJMSConnection4 = null;
                if (lock != null) {
                    lock.close();
                }
                nTFJMSConnection = nTFJMSConnection4;
                if (!bl) break block16;
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, nTFJMSConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, null);
            }
            return nTFJMSConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void resetRegistrationNumbers(int n2, NTFJMSConnection nTFJMSConnection) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, n2, nTFJMSConnection);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void ntfJMSConnection;
                void nbOfRegistration;
                this.noOfRegistrationsInThisGroup -= nbOfRegistration;
                if (ntfJMSConnection != null) {
                    ntfJMSConnection.decrementNumberOfRegistrations((int)nbOfRegistration);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, throwable4);
            }
            throw throwable;
        }
    }

    void raiseException() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                --this.aliveConnections;
                if (this.aliveConnections == 0) {
                    NTFJMSRegistration ntfReg = null;
                    Iterator<Long> regIdIter = this.jmsRegIdToNtfReg.keySet().iterator();
                    while (regIdIter.hasNext()) {
                        ntfReg = this.jmsRegIdToNtfReg.get(regIdIter.next());
                        try {
                            ntfReg.raiseException(1);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addNtfRegistrationByRegId(long l2, NTFJMSRegistration nTFJMSRegistration) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void ntfReg;
            void jmsRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this, l2, nTFJMSRegistration);
            }
            this.jmsRegIdToNtfReg.put((long)jmsRegId, (NTFJMSRegistration)ntfReg);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFJMSRegistration getNtfRegistrationByRegId(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, l2);
            }
            NTFJMSRegistration nTFJMSRegistration = this.jmsRegIdToNtfReg.get((long)jmsRegId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, nTFJMSRegistration);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, null);
            }
            return nTFJMSRegistration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFJMSRegistration removeNtfRegistrationByRegId(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, l2);
            }
            NTFJMSRegistration nTFJMSRegistration = this.jmsRegIdToNtfReg.remove((long)jmsRegId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, nTFJMSRegistration);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, null);
            }
            return nTFJMSRegistration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void stopNTFJMSConnection(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsConnectionId;
            Monitor.CloseableLock lock;
            block15: {
                block16: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, string);
                    }
                    lock = this.acquireCloseableLock();
                    if (jmsConnectionId != null && jmsConnectionId.length() != 0) break block15;
                    if (lock != null) {
                        lock.close();
                    }
                    if (!bl) break block16;
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, null);
                }
                return;
            }
            try {
                for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                    if (listenerConnection == null || !jmsConnectionId.equals(listenerConnection.getJMSConnectionId())) continue;
                    listenerConnection.decrementNumberOfRegistrations(1);
                    if (listenerConnection.getNumberOfRegistrations() > 0) break;
                    listenerConnection.setNeedToBeClosed(true);
                    break;
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$13 = NTFJMSConnectionGroup.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFJMSConnectionGroup.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFJMSConnectionGroup.class.getDeclaredMethod("stopNTFJMSConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSConnectionGroup.class.getDeclaredMethod("removeNtfRegistrationByRegId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSConnectionGroup.class.getDeclaredMethod("getNtfRegistrationByRegId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSConnectionGroup.class.getDeclaredMethod("addNtfRegistrationByRegId", Long.TYPE, NTFJMSRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSConnectionGroup.class.getDeclaredMethod("raiseException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSConnectionGroup.class.getDeclaredMethod("resetRegistrationNumbers", Integer.TYPE, NTFJMSConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSConnectionGroup.class.getDeclaredMethod("getNTFJMSConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSConnectionGroup.class.getDeclaredMethod("decrementNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSConnectionGroup.class.getDeclaredMethod("startJMSListenerConnection", String.class, String.class, String.class, OpaqueString.class, ArrayList.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSConnectionGroup.class.getDeclaredMethod("checkForActiveRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSConnectionGroup.class.getDeclaredMethod("getMaxNtfConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSConnectionGroup.class.getDeclaredMethod("setMaxNtfConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        MAX_NTF_CONNECTIONS = 0;
        MAX_NTF_CONNECTIONS_MONITOR = Monitor.newInstance();
    }
}

