/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class Redirector<T> {
    private final Class<T> type;
    private static final HashMap<Class<?>, Redirector<?>> CLASS_TO_REDIRECTOR;
    private static final HashMap<Class<?>, Redirector<?>> CLASS_TO_ERROR;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    private Redirector(Class<T> _type) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, Redirector.class, $$$methodRef$$$6, null, _type);
            }
            this.type = _type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, Redirector.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Redirector.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Redirector.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    abstract T redirect(Accessor var1, int var2) throws SQLException;

    final Class<T> getTarget() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, Redirector.class, $$$methodRef$$$0, this, new Object[0]);
            }
            Class<T> clazz = this.type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Redirector.class, $$$methodRef$$$0, this, clazz);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Redirector.class, $$$methodRef$$$0, this, null);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Redirector.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return super.toString() + "[" + this.type.getName() + "]";
    }

    static <V> Redirector<V> createObjectRedirector(Class<V> clazz) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Class<V> target;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, Redirector.class, $$$methodRef$$$1, null, clazz);
            }
            Redirector redirector = new Redirector<V>((Class)target){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                final V redirect(Accessor acc, int currentRow) throws SQLException {
                    try {
                        Object obj = acc.getObject(currentRow);
                        Class targetType = this.getTarget();
                        if (obj != null && !targetType.isInstance(obj)) {
                            throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)1.getConnectionDuringExceptionHandling(), 49, targetType.getName()).fillInStackTrace();
                        }
                        return obj;
                    }
                    catch (ClassCastException ex) {
                        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)1.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Redirector.class, $$$methodRef$$$1, null, redirector);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Redirector.class, $$$methodRef$$$1, null, null);
            }
            return redirector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Redirector.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static <V> Redirector<V> createValueOfRedirector(Class<V> clazz, List<Class<?>> list) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Class<V> target;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, Redirector.class, $$$methodRef$$$2, null, clazz, list);
            }
            if (Modifier.isPublic(target.getModifiers())) {
                Method[] methods = target.getDeclaredMethods();
                int desireable = Integer.MAX_VALUE;
                Method method = null;
                Class type = null;
                for (Method m2 : methods) {
                    if (Modifier.isStatic(m2.getModifiers()) && Modifier.isPublic(m2.getModifiers()) && m2.getName().equals("valueOf") && m2.getParameterTypes().length == 1 && target.isAssignableFrom(m2.getReturnType())) {
                        void supportedTypes;
                        int i2 = 0;
                        for (Class t2 : supportedTypes) {
                            if (m2.getParameterTypes()[0].isAssignableFrom(t2)) {
                                if (i2 >= desireable) break;
                                desireable = i2;
                                method = m2;
                                type = t2;
                                break;
                            }
                            ++i2;
                        }
                    }
                    if (desireable == 0) break;
                }
                if (method != null) {
                    Redirector<V> redirector = Redirector.createValueOfRedirector(target, method, type);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Redirector.class, $$$methodRef$$$2, null, redirector);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Redirector.class, $$$methodRef$$$2, null, null);
                    }
                    return redirector;
                }
            }
            Redirector redirector = new Redirector<V>((Class)target){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                final V redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)2.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Redirector.class, $$$methodRef$$$2, null, redirector);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Redirector.class, $$$methodRef$$$2, null, null);
            }
            return redirector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Redirector.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <V, W> Redirector<V> createValueOfRedirector(Class<V> clazz, Method method, Class<W> clazz2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void staticValueOf;
            Class<V> target;
            void supportedType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, Redirector.class, $$$methodRef$$$3, null, clazz, method, clazz2);
            }
            Redirector<?> supportedRedirector = CLASS_TO_REDIRECTOR.get(supportedType);
            Redirector redirector = new Redirector<V>(target, (Method)staticValueOf, supportedRedirector){
                final /* synthetic */ Method val$staticValueOf;
                final /* synthetic */ Redirector val$supportedRedirector;
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                {
                    this.val$staticValueOf = method;
                    this.val$supportedRedirector = redirector;
                    super(_type);
                }

                @Override
                final V redirect(Accessor acc, int currentRow) throws SQLException {
                    try {
                        if (acc.isNull(currentRow)) {
                            return null;
                        }
                        return this.val$staticValueOf.invoke(null, this.val$supportedRedirector.redirect(acc, currentRow));
                    }
                    catch (IllegalAccessException ex) {
                        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)3.getConnectionDuringExceptionHandling(), 1, ex.getMessage()).fillInStackTrace();
                    }
                    catch (IllegalArgumentException ex) {
                        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)3.getConnectionDuringExceptionHandling(), 1, ex.getMessage()).fillInStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        if (ex.getTargetException() instanceof SQLException) {
                            throw (SQLException)ex.getTargetException();
                        }
                        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)3.getConnectionDuringExceptionHandling(), 1, "Got something other than a SQLException: " + ex.getTargetException()).fillInStackTrace();
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Class.class, Method.class, Redirector.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 3.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, Redirector.class, $$$methodRef$$$3, null, redirector);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Redirector.class, $$$methodRef$$$3, null, null);
            }
            return redirector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Redirector.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    static Map<Class<?>, Redirector<?>> createRedirectorMap(Collection<Class<?>> collection) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Collection<Class<?>> supportedTypes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, Redirector.class, $$$methodRef$$$4, null, collection);
            }
            Map m2 = (Map)CLASS_TO_ERROR.clone();
            for (Class<?> t2 : supportedTypes) {
                if (!$assertionsDisabled && CLASS_TO_REDIRECTOR.get(t2) == null) {
                    AssertionError assertionError = new AssertionError(t2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, Redirector.class, $$$methodRef$$$4, null, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                m2.put(t2, CLASS_TO_REDIRECTOR.get(t2));
            }
            Map map = m2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, Redirector.class, $$$methodRef$$$4, null, map);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Redirector.class, $$$methodRef$$$4, null, null);
            }
            return map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Redirector.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    static OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, Redirector.class, $$$methodRef$$$5, null, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, Redirector.class, $$$methodRef$$$5, null, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Redirector.class, $$$methodRef$$$5, null, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Redirector.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = Redirector.class.getDeclaredConstructor(Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Redirector.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Redirector.class.getDeclaredMethod("createRedirectorMap", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Redirector.class.getDeclaredMethod("createValueOfRedirector", Class.class, Method.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Redirector.class.getDeclaredMethod("createValueOfRedirector", Class.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Redirector.class.getDeclaredMethod("createObjectRedirector", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Redirector.class.getDeclaredMethod("getTarget", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        CLASS_TO_REDIRECTOR = new HashMap();
        CLASS_TO_REDIRECTOR.put(Array.class, new Redirector<Array>(Array.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Array redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getARRAY(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(BigDecimal.class, new Redirector<BigDecimal>(BigDecimal.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BigDecimal redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBigDecimal(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 5.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Blob.class, new Redirector<Blob>(Blob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Blob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 6.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 6.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 6.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Boolean.class, new Redirector<Boolean>(Boolean.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Boolean redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBoolean(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 7.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Byte.class, new Redirector<Byte>(Byte.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Byte redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getByte(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 8.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(byte[].class, new Redirector<byte[]>(byte[].class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final byte[] redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBytes(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 9.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 9.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 9.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Clob.class, new Redirector<Clob>(Clob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Clob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 10.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 10.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 10.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(java.sql.Date.class, new Redirector<java.sql.Date>(java.sql.Date.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final java.sql.Date redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDate(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 11.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 11.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 11.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Double.class, new Redirector<Double>(Double.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Double redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDouble(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 12.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 12.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 12.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Float.class, new Redirector<Float>(Float.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Float redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return Float.valueOf(acc.getFloat(currentRow));
            }

            static {
                try {
                    $$$methodRef$$$2 = 13.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 13.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 13.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Integer.class, new Redirector<Integer>(Integer.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Integer redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getInt(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 14.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 14.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 14.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Long.class, new Redirector<Long>(Long.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Long redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLong(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 15.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 15.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 15.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(NClob.class, new Redirector<NClob>(NClob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final NClob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNClob(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 16.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 16.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 16.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Ref.class, new Redirector<Ref>(Ref.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Ref redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getREF(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 17.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 17.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 17.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(RowId.class, new Redirector<RowId>(RowId.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final RowId redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getROWID(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 18.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 18.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 18.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Short.class, new Redirector<Short>(Short.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Short redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getShort(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 19.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 19.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 19.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(SQLXML.class, new Redirector<SQLXML>(SQLXML.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final SQLXML redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getSQLXML(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 20.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 20.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 20.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(String.class, new Redirector<String>(String.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final String redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getString(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 21.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 21.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 21.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Struct.class, new Redirector<Struct>(Struct.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Struct redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getStruct(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 22.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 22.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 22.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Time.class, new Redirector<Time>(Time.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Time redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTime(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 23.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 23.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 23.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Timestamp.class, new Redirector<Timestamp>(Timestamp.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Timestamp redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTimestamp(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 24.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 24.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 24.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(URL.class, new Redirector<URL>(URL.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final URL redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getURL(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 25.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 25.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 25.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(BigInteger.class, new Redirector<BigInteger>(BigInteger.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BigInteger redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBigInteger(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 26.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 26.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 26.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Date.class, new Redirector<Date>(Date.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Date redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getJavaUtilDate(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 27.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 27.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 27.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Calendar.class, new Redirector<Calendar>(Calendar.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Calendar redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCalendar(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 28.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 28.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 28.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Duration.class, new Redirector<Duration>(Duration.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Duration redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDuration(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 29.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 29.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 29.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(LocalDate.class, new Redirector<LocalDate>(LocalDate.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final LocalDate redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLocalDate(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 30.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 30.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 30.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(LocalDateTime.class, new Redirector<LocalDateTime>(LocalDateTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final LocalDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLocalDateTime(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 31.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 31.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 31.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(LocalTime.class, new Redirector<LocalTime>(LocalTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final LocalTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLocalTime(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 32.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 32.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 32.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OffsetDateTime.class, new Redirector<OffsetDateTime>(OffsetDateTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OffsetDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOffsetDateTime(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 33.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 33.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 33.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OffsetTime.class, new Redirector<OffsetTime>(OffsetTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OffsetTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOffsetTime(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 34.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 34.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 34.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Period.class, new Redirector<Period>(Period.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Period redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getPeriod(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 35.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 35.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 35.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(ZonedDateTime.class, new Redirector<ZonedDateTime>(ZonedDateTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ZonedDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getZonedDateTime(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 36.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 36.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 36.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(ARRAY.class, new Redirector<ARRAY>(ARRAY.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ARRAY redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getARRAY(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 37.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 37.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 37.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(BFILE.class, new Redirector<BFILE>(BFILE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BFILE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBFILE(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 38.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 38.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 38.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(BINARY_FLOAT.class, new Redirector<BINARY_FLOAT>(BINARY_FLOAT.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BINARY_FLOAT redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBINARY_FLOAT(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 39.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 39.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 39.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(BINARY_DOUBLE.class, new Redirector<BINARY_DOUBLE>(BINARY_DOUBLE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BINARY_DOUBLE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBINARY_DOUBLE(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 40.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 40.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 40.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(BLOB.class, new Redirector<BLOB>(BLOB.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BLOB redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 41.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 41.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 41.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(CHAR.class, new Redirector<CHAR>(CHAR.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final CHAR redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCHAR(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 42.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 42.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 42.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(CLOB.class, new Redirector<CLOB>(CLOB.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final CLOB redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 43.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 43.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 43.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(ResultSet.class, new Redirector<ResultSet>(ResultSet.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ResultSet redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCursor(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 44.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 44.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 44.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(DATE.class, new Redirector<DATE>(DATE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final DATE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDATE(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 45.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 45.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 45.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(INTERVALDS.class, new Redirector<INTERVALDS>(INTERVALDS.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final INTERVALDS redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getINTERVALDS(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 46.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 46.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 46.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(INTERVALYM.class, new Redirector<INTERVALYM>(INTERVALYM.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final INTERVALYM redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getINTERVALYM(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 47.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 47.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 47.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(NCLOB.class, new Redirector<NCLOB>(NCLOB.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final NCLOB redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNCLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 48.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 48.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 48.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(NUMBER.class, new Redirector<NUMBER>(NUMBER.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final NUMBER redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNUMBER(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 49.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 49.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 49.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OPAQUE.class, new Redirector<OPAQUE>(OPAQUE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OPAQUE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOPAQUE(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 50.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 50.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 50.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(ORAData.class, new Redirector<ORAData>(ORAData.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ORAData redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getORAData(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 51.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 51.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 51.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleData.class, new Redirector<OracleData>(OracleData.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleData redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleData(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 52.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 52.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 52.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(RAW.class, new Redirector<RAW>(RAW.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final RAW redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getRAW(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 53.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 53.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 53.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(REF.class, new Redirector<REF>(REF.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final REF redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getREF(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 54.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 54.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 54.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(ROWID.class, new Redirector<ROWID>(ROWID.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ROWID redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getROWID(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 55.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 55.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 55.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(STRUCT.class, new Redirector<STRUCT>(STRUCT.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final STRUCT redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getSTRUCT(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 56.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 56.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 56.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMPLTZ.class, new Redirector<TIMESTAMPLTZ>(TIMESTAMPLTZ.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final TIMESTAMPLTZ redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTIMESTAMPLTZ(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 57.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 57.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 57.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMPTZ.class, new Redirector<TIMESTAMPTZ>(TIMESTAMPTZ.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final TIMESTAMPTZ redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTIMESTAMPTZ(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 58.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 58.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 58.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMP.class, new Redirector<TIMESTAMP>(TIMESTAMP.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final TIMESTAMP redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTIMESTAMP(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 59.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 59.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 59.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleArray.class, new Redirector<OracleArray>(OracleArray.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleArray redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getARRAY(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 60.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 60.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 60.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleBfile.class, new Redirector<OracleBfile>(OracleBfile.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleBfile redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBFILE(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 61.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 61.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 61.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleBlob.class, new Redirector<OracleBlob>(OracleBlob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleBlob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 62.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 62.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 62.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleClob.class, new Redirector<OracleClob>(OracleClob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleClob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 63.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 63.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 63.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleNClob.class, new Redirector<OracleNClob>(OracleNClob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleNClob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNCLOB(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 64.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 64.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 64.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleOpaque.class, new Redirector<OracleOpaque>(OracleOpaque.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleOpaque redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOPAQUE(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 65.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 65.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 65.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleRef.class, new Redirector<OracleRef>(OracleRef.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleRef redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getREF(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 66.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 66.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 66.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleStruct.class, new Redirector<OracleStruct>(OracleStruct.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleStruct redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getSTRUCT(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 67.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 67.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 67.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(InputStream.class, new Redirector<InputStream>(InputStream.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final InputStream redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBinaryStream(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 68.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 68.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 68.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Reader.class, new Redirector<Reader>(Reader.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Reader redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCharacterStream(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 69.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 69.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 69.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        if (PhysicalConnection.isJsonJarPresent()) {
            CLASS_TO_REDIRECTOR.put(JsonValue.class, new Redirector<JsonValue>(JsonValue.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonValue(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 70.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 70.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 70.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonParser.class, new Redirector<JsonParser>(JsonParser.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonParser(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 71.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 71.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 71.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonStructure.class, new Redirector<JsonStructure>(JsonStructure.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonStructure(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 72.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 72.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 72.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonObject.class, new Redirector<JsonObject>(JsonObject.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonObject(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 73.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 73.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 73.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonArray.class, new Redirector<JsonArray>(JsonArray.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonArray(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 74.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 74.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 74.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonString.class, new Redirector<JsonString>(JsonString.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonString redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonString(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 75.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 75.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 75.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonNumber.class, new Redirector<JsonNumber>(JsonNumber.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonNumber(currentRow);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 76.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 76.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 76.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
        }
        CLASS_TO_REDIRECTOR.put(OracleJsonValue.class, new Redirector<OracleJsonValue>(OracleJsonValue.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonValue(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 77.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 77.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 77.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonStructure.class, new Redirector<OracleJsonStructure>(OracleJsonStructure.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonStructure(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 78.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 78.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 78.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonObject.class, new Redirector<OracleJsonObject>(OracleJsonObject.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonObject(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 79.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 79.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 79.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonArray.class, new Redirector<OracleJsonArray>(OracleJsonArray.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonArray(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 80.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 80.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 80.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonString.class, new Redirector<OracleJsonString>(OracleJsonString.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonString redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonString(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 81.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 81.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 81.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonNumber.class, new Redirector<OracleJsonNumber>(OracleJsonNumber.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonNumber(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 82.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 82.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 82.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDecimal.class, new Redirector<OracleJsonDecimal>(OracleJsonDecimal.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonDecimal redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDecimal(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 83.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 83.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 83.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonFloat.class, new Redirector<OracleJsonFloat>(OracleJsonFloat.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonFloat redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonFloat(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 84.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 84.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 84.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDouble.class, new Redirector<OracleJsonDouble>(OracleJsonDouble.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonDouble redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDouble(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 85.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 85.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 85.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonTimestamp.class, new Redirector<OracleJsonTimestamp>(OracleJsonTimestamp.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonTimestamp redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonTimestamp(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 86.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 86.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 86.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDate.class, new Redirector<OracleJsonDate>(OracleJsonDate.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonDate redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDate(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 87.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 87.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 87.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonBinary.class, new Redirector<OracleJsonBinary>(OracleJsonBinary.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonBinary redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonBinary(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 88.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 88.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 88.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonIntervalDS.class, new Redirector<OracleJsonIntervalDS>(OracleJsonIntervalDS.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonIntervalDS redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonIntervalDS(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 89.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 89.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 89.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonIntervalYM.class, new Redirector<OracleJsonIntervalYM>(OracleJsonIntervalYM.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonIntervalYM redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonIntervalYM(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 90.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 90.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 90.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDatum.class, new Redirector<OracleJsonDatum>(OracleJsonDatum.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonDatum redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDatum(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 91.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 91.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 91.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(Datum.class, new Redirector<Datum>(Datum.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Datum redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDatum(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 92.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 92.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 92.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonParser.class, new Redirector<OracleJsonParser>(OracleJsonParser.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleJsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonParser(currentRow);
            }

            static {
                try {
                    $$$methodRef$$$2 = 93.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 93.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 93.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR = new HashMap();
        CLASS_TO_ERROR.put(Array.class, new Redirector<Array>(Array.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Array redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)94.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 94.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 94.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 94.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(BigDecimal.class, new Redirector<BigDecimal>(BigDecimal.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BigDecimal redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)95.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 95.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 95.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 95.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Blob.class, new Redirector<Blob>(Blob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Blob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)96.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 96.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 96.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 96.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Boolean.class, new Redirector<Boolean>(Boolean.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Boolean redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)97.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 97.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 97.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 97.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Byte.class, new Redirector<Byte>(Byte.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Byte redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)98.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 98.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 98.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 98.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(byte[].class, new Redirector<byte[]>(byte[].class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final byte[] redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)99.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 99.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 99.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 99.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Clob.class, new Redirector<Clob>(Clob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Clob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)100.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 100.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 100.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 100.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(java.sql.Date.class, new Redirector<java.sql.Date>(java.sql.Date.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final java.sql.Date redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)101.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 101.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 101.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 101.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Double.class, new Redirector<Double>(Double.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Double redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)102.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 102.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 102.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 102.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Float.class, new Redirector<Float>(Float.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Float redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)103.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 103.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 103.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 103.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Integer.class, new Redirector<Integer>(Integer.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Integer redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)104.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 104.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 104.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 104.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Long.class, new Redirector<Long>(Long.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Long redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)105.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 105.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 105.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 105.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(NClob.class, new Redirector<NClob>(NClob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final NClob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)106.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 106.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 106.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 106.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Ref.class, new Redirector<Ref>(Ref.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Ref redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)107.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 107.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 107.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 107.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(RowId.class, new Redirector<RowId>(RowId.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final RowId redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)108.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 108.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 108.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 108.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Short.class, new Redirector<Short>(Short.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Short redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)109.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 109.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 109.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 109.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(SQLXML.class, new Redirector<SQLXML>(SQLXML.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final SQLXML redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)110.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 110.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 110.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 110.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(String.class, new Redirector<String>(String.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final String redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)111.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 111.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 111.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 111.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Struct.class, new Redirector<Struct>(Struct.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Struct redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)112.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 112.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 112.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 112.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Time.class, new Redirector<Time>(Time.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Time redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)113.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 113.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 113.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 113.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Timestamp.class, new Redirector<Timestamp>(Timestamp.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Timestamp redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)114.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 114.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 114.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 114.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(URL.class, new Redirector<URL>(URL.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final URL redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)115.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 115.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 115.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 115.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(BigInteger.class, new Redirector<BigInteger>(BigInteger.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BigInteger redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)116.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 116.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 116.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 116.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Date.class, new Redirector<Date>(Date.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Date redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)117.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 117.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 117.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 117.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Calendar.class, new Redirector<Calendar>(Calendar.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Calendar redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)118.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 118.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 118.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 118.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Duration.class, new Redirector<Duration>(Duration.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Duration redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)119.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 119.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 119.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 119.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(LocalDate.class, new Redirector<LocalDate>(LocalDate.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final LocalDate redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)120.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 120.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 120.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 120.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(LocalDateTime.class, new Redirector<LocalDateTime>(LocalDateTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final LocalDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)121.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 121.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 121.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 121.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(LocalTime.class, new Redirector<LocalTime>(LocalTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final LocalTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)122.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 122.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 122.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 122.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OffsetDateTime.class, new Redirector<OffsetDateTime>(OffsetDateTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OffsetDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)123.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 123.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 123.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 123.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OffsetTime.class, new Redirector<OffsetTime>(OffsetTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OffsetTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)124.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 124.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 124.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 124.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Period.class, new Redirector<Period>(Period.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Period redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)125.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 125.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 125.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 125.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(ZonedDateTime.class, new Redirector<ZonedDateTime>(ZonedDateTime.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ZonedDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)126.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 126.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 126.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 126.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(ARRAY.class, new Redirector<ARRAY>(ARRAY.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ARRAY redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)127.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 127.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 127.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 127.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(BFILE.class, new Redirector<BFILE>(BFILE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BFILE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)128.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 128.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 128.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 128.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(BINARY_FLOAT.class, new Redirector<BINARY_FLOAT>(BINARY_FLOAT.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BINARY_FLOAT redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)129.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 129.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 129.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 129.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(BINARY_DOUBLE.class, new Redirector<BINARY_DOUBLE>(BINARY_DOUBLE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BINARY_DOUBLE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)130.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 130.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 130.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 130.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(BLOB.class, new Redirector<BLOB>(BLOB.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final BLOB redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)131.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 131.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 131.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 131.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(CHAR.class, new Redirector<CHAR>(CHAR.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final CHAR redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)132.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 132.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 132.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 132.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(CLOB.class, new Redirector<CLOB>(CLOB.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final CLOB redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)133.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 133.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 133.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 133.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(ResultSet.class, new Redirector<ResultSet>(ResultSet.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ResultSet redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)134.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 134.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 134.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 134.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(DATE.class, new Redirector<DATE>(DATE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final DATE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)135.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 135.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 135.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 135.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(INTERVALDS.class, new Redirector<INTERVALDS>(INTERVALDS.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final INTERVALDS redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)136.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 136.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 136.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 136.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(INTERVALYM.class, new Redirector<INTERVALYM>(INTERVALYM.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final INTERVALYM redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)137.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 137.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 137.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 137.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(NCLOB.class, new Redirector<NCLOB>(NCLOB.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final NCLOB redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)138.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 138.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 138.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 138.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(NUMBER.class, new Redirector<NUMBER>(NUMBER.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final NUMBER redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)139.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 139.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 139.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 139.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OPAQUE.class, new Redirector<OPAQUE>(OPAQUE.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OPAQUE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)140.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 140.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 140.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 140.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(ORAData.class, new Redirector<ORAData>(ORAData.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ORAData redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)141.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 141.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 141.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 141.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleData.class, new Redirector<OracleData>(OracleData.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleData redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)142.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 142.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 142.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 142.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(RAW.class, new Redirector<RAW>(RAW.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final RAW redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)143.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 143.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 143.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 143.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(REF.class, new Redirector<REF>(REF.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final REF redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)144.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 144.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 144.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 144.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(ROWID.class, new Redirector<ROWID>(ROWID.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final ROWID redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)145.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 145.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 145.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 145.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(STRUCT.class, new Redirector<STRUCT>(STRUCT.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final STRUCT redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)146.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 146.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 146.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 146.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMPLTZ.class, new Redirector<TIMESTAMPLTZ>(TIMESTAMPLTZ.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final TIMESTAMPLTZ redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)147.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 147.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 147.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 147.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMPTZ.class, new Redirector<TIMESTAMPTZ>(TIMESTAMPTZ.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final TIMESTAMPTZ redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)148.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 148.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 148.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 148.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMP.class, new Redirector<TIMESTAMP>(TIMESTAMP.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final TIMESTAMP redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)149.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 149.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 149.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 149.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleArray.class, new Redirector<OracleArray>(OracleArray.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleArray redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)150.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 150.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 150.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 150.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleBfile.class, new Redirector<OracleBfile>(OracleBfile.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleBfile redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)151.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 151.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 151.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 151.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleBlob.class, new Redirector<OracleBlob>(OracleBlob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleBlob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)152.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 152.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 152.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 152.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleClob.class, new Redirector<OracleClob>(OracleClob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleClob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)153.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 153.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 153.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 153.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleNClob.class, new Redirector<OracleNClob>(OracleNClob.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleNClob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)154.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 154.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 154.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 154.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleOpaque.class, new Redirector<OracleOpaque>(OracleOpaque.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleOpaque redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)155.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 155.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 155.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 155.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleRef.class, new Redirector<OracleRef>(OracleRef.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleRef redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)156.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 156.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 156.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 156.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(OracleStruct.class, new Redirector<OracleStruct>(OracleStruct.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final OracleStruct redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)157.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 157.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 157.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 157.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(InputStream.class, new Redirector<InputStream>(InputStream.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final InputStream redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)158.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 158.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 158.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 158.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CLASS_TO_ERROR.put(Reader.class, new Redirector<Reader>(Reader.class){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            final Reader redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)159.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }

            static {
                try {
                    $$$methodRef$$$2 = 159.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 159.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 159.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        if (PhysicalConnection.isJsonJarPresent()) {
            CLASS_TO_ERROR.put(JsonValue.class, new Redirector<JsonValue>(JsonValue.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)160.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 160.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 160.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 160.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_ERROR.put(JsonParser.class, new Redirector<JsonParser>(JsonParser.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)161.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 161.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 161.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 161.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_ERROR.put(JsonStructure.class, new Redirector<JsonStructure>(JsonStructure.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)162.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 162.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 162.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 162.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_ERROR.put(JsonObject.class, new Redirector<JsonObject>(JsonObject.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)163.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 163.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 163.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 163.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_ERROR.put(JsonArray.class, new Redirector<JsonArray>(JsonArray.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)164.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 164.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 164.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 164.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_ERROR.put(JsonString.class, new Redirector<JsonString>(JsonString.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonString redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)165.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 165.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 165.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 165.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            CLASS_TO_ERROR.put(JsonNumber.class, new Redirector<JsonNumber>(JsonNumber.class){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                final JsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)166.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }

                static {
                    try {
                        $$$methodRef$$$2 = 166.class.getDeclaredConstructor(Class.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 166.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 166.class.getDeclaredMethod("redirect", Accessor.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
        }
    }
}

