/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.LongSummaryStatistics;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.JsonWebToken;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.Clock;
import oracle.net.nt.TimeoutInterruptHandler;

public final class JsonWebTokenCache
implements Supplier<JsonWebToken> {
    private static final long EXPIRATION_THRESHOLD = 30000L;
    private static final long UPDATE_THRESHOLD = 60000L;
    private final Supplier<JsonWebToken> tokenSupplier;
    private final Executor executor;
    private final LongSummaryStatistics latency = new LongSummaryStatistics();
    private final AtomicInteger getCount = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition updateCondition = this.lock.newCondition();
    private boolean isUpdating = false;
    private JsonWebToken token = null;
    private RuntimeException failure;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public static JsonWebTokenCache create(Supplier<? extends AccessToken> tokenSupplier) {
        try {
            return new JsonWebTokenCache(OracleDriver.getExecutorService(), () -> JsonWebTokenCache.requireJsonWebToken((AccessToken)tokenSupplier.get()));
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException(sqlException);
        }
    }

    private JsonWebTokenCache(Executor executor, @Blind Supplier<JsonWebToken> tokenSupplier) {
        this.executor = executor;
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    @Blind
    public JsonWebToken get() {
        this.getCount.incrementAndGet();
        JsonWebToken cachedToken = this.token;
        if (cachedToken != null && !JsonWebTokenCache.isExpiring(cachedToken)) {
            return cachedToken;
        }
        this.lock.lock();
        try {
            while (cachedToken == this.token && this.failure == null) {
                if (!this.isUpdating) {
                    this.isUpdating = true;
                    this.requestUpdate();
                }
                this.updateCondition.await();
            }
            if (this.failure != null) {
                RuntimeException updateFailure = this.failure;
                this.failure = null;
                throw updateFailure;
            }
            JsonWebToken updateFailure = this.token;
            return updateFailure;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void requestUpdate() {
        this.executor.execute(() -> {
            try {
                long start = System.nanoTime();
                JsonWebToken token = this.tokenSupplier.get();
                this.latency.accept(System.nanoTime() - start);
                this.update(token, null);
            }
            catch (RuntimeException failure) {
                this.update(null, failure);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@Blind JsonWebToken token, RuntimeException failure) {
        boolean isUpdating = this.getCount.getAndSet(0) != 0 && failure == null;
        this.lock.lock();
        try {
            this.token = token;
            this.failure = failure;
            this.isUpdating = isUpdating;
            this.updateCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (isUpdating) {
            this.scheduleUpdate(TimeUnit.SECONDS.toMillis(token.exp()));
        }
    }

    private void scheduleUpdate(long expireTimeMillis) {
        long updateLatency = TimeUnit.NANOSECONDS.toMillis(Math.round(this.latency.getAverage() * 1.2));
        long expirationDelay = expireTimeMillis - 60000L - System.currentTimeMillis();
        TimeoutInterruptHandler.scheduleTask(this::requestUpdate, Math.max(0L, expirationDelay - updateLatency));
    }

    private static boolean isExpiring(@Blind JsonWebToken jsonWebToken) {
        return Clock.currentTimeMillis() + 30000L >= TimeUnit.SECONDS.toMillis(jsonWebToken.exp());
    }

    @Blind
    private static JsonWebToken requireJsonWebToken(@Blind AccessToken accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("token supplier has output a null value");
        }
        if (!(accessToken instanceof JsonWebToken)) {
            throw new IllegalArgumentException("token supplier has output an unrecognized object type: " + accessToken.getClass());
        }
        return (JsonWebToken)accessToken;
    }

    static {
        try {
            $$$methodRef$$$10 = JsonWebTokenCache.class.getDeclaredConstructor(Executor.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonWebTokenCache.class.getDeclaredMethod("lambda$create$0", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonWebTokenCache.class.getDeclaredMethod("lambda$requestUpdate$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonWebTokenCache.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonWebTokenCache.class.getDeclaredMethod("requireJsonWebToken", AccessToken.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonWebTokenCache.class.getDeclaredMethod("isExpiring", JsonWebToken.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonWebTokenCache.class.getDeclaredMethod("scheduleUpdate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonWebTokenCache.class.getDeclaredMethod("update", JsonWebToken.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonWebTokenCache.class.getDeclaredMethod("requestUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonWebTokenCache.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonWebTokenCache.class.getDeclaredMethod("create", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

