/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BooleanBinder;
import oracle.jdbc.driver.BooleanBinder21c;
import oracle.jdbc.driver.BooleanNullBinder;
import oracle.jdbc.driver.BooleanNullBinder21c;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CBooleanAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CJsonAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CPlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CRowidBinder;
import oracle.jdbc.driver.T4CRowidNullBinder;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CURowidBinder;
import oracle.jdbc.driver.T4CURowidNullBinder;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.driver.T4CVectorAccessor;
import oracle.jdbc.driver.VarcharNullBinder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeTIMESTAMP;
import oracle.sql.Datum;

class T4CCallableStatement
extends OracleCallableStatement {
    private final String CLASS_NAME = this.getClass().getName();
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private long beyondRowData = 0L;
    private T4C8Oall streamingOAll = null;
    final String[] nlsStrings = new String[]{"AUTH_NLS_LXLAN", "AUTH_NLS_LXCTERRITORY", "AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", "AUTH_NLS_LXCUNIONCUR", "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_TIME_ZONE", "AL8KW_ENABLED_ROLES", "AL8KW_ERR_OVLAP", "AL8KW_EDITION", "AL8KW_AUX_SESSSTATE"};

    T4CCallableStatement(PhysicalConnection connection, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        super(connection, sql, resultSetType);
        this.t4Connection = (T4CConnection)connection;
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
    }

    @Override
    protected Binder createRowidBinder(byte[] rowidBytes) throws SQLException {
        return new T4CRowidBinder(rowidBytes);
    }

    @Override
    protected Binder createURowidBinder(byte[] rowidBytes) throws SQLException {
        return new T4CURowidBinder(rowidBytes);
    }

    @Override
    protected Binder createRowidNullBinder() throws SQLException {
        return new T4CRowidNullBinder();
    }

    @Override
    protected Binder createURowidNullBinder() throws SQLException {
        return new T4CURowidNullBinder();
    }

    @Override
    protected Binder createBooleanBinder(boolean x) throws SQLException {
        boolean sendBooleanAsBoolean;
        short versionNumber = this.connection.getVersionNumber();
        boolean bl = sendBooleanAsBoolean = this.connection.sendBooleanAsNativeBoolean && this.connection.sendBooleanInPLSQL;
        if (this.sqlKind.isPlsqlOrCall()) {
            if (versionNumber >= 23000 && sendBooleanAsBoolean) {
                return new BooleanBinder(x ? 1 : 0);
            }
            return new BooleanBinder21c(x ? 1 : 0);
        }
        if (versionNumber >= 23000 && this.connection.sendBooleanAsNativeBoolean) {
            return new BooleanBinder(x ? 1 : 0);
        }
        return new BooleanBinder21c(x ? 1 : 0);
    }

    @Override
    protected Binder createBooleanNullBinder() throws SQLException {
        boolean sendBooleanAsBoolean;
        short versionNumber = this.connection.getVersionNumber();
        boolean bl = sendBooleanAsBoolean = this.connection.sendBooleanAsNativeBoolean && this.connection.sendBooleanInPLSQL;
        if (this.sqlKind.isPlsqlOrCall()) {
            if (versionNumber >= 23000 && sendBooleanAsBoolean) {
                return new BooleanNullBinder();
            }
            return BooleanNullBinder21c.getInstance();
        }
        if (versionNumber >= 23000 && this.connection.sendBooleanAsNativeBoolean) {
            return new BooleanNullBinder();
        }
        return BooleanNullBinder21c.getInstance();
    }

    @Override
    protected boolean prepareDefineBufferOnRowPrefetchChange() {
        return false;
    }

    @Override
    void prepareForNewResults(boolean resetPrefetch, boolean clearStreamList, boolean clearImplicitResults) throws SQLException {
        super.prepareForNewResults(resetPrefetch, clearStreamList, clearImplicitResults);
        this.beyondRowData = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOall8(T4C8Oall all8, boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine) throws SQLException, IOException {
        int rowsToFetch = this.prepareForOALL8(doFetch);
        if (rowsToFetch == -1) {
            return;
        }
        boolean isRowIdPrefixed = doDefine && doDescribe && this.isRowidPrepended;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, this.CLASS_NAME, "doOall8", "doParse={0}, doExecute={1}, doFetch={2}, doDescribe={3}, doDefine={4}, isRowIdPrefixed={5}. ", (String)null, (Throwable)null, (Object)doParse, (Object)doExecute, (Object)doFetch, (Object)doDescribe, (Object)doDefine, (Object)isRowIdPrefixed);
        this.initializeOall8(all8, isRowIdPrefixed, rowsToFetch);
        try {
            all8.doOALL(doParse, doExecute, doFetch, doDescribe, doDefine);
        }
        catch (SQLException ea) {
            if (!this.handleOall8Failure(ea)) {
                throw ea;
            }
        }
        finally {
            this.handleOall8CompletionAlways(all8);
        }
    }

    final void doOall8Async(T4C8Oall all8, boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine, Consumer<Throwable> callback) {
        int rowsToFetch;
        try {
            rowsToFetch = this.prepareForOALL8(doFetch);
        }
        catch (SQLException sqlException) {
            callback.accept(sqlException);
            return;
        }
        if (rowsToFetch == -1) {
            callback.accept(null);
            return;
        }
        all8.oracleStatement = this;
        all8.doOALLAsync(doParse, doExecute, doFetch, doDescribe, doDefine, this.getContinueOnErrorSet(), () -> {
            if (doExecute) {
                this.setupBindBuffers();
            }
            boolean isRowIdPrefixed = doDefine && doDescribe && this.isRowidPrepended;
            this.initializeOall8(all8, isRowIdPrefixed, rowsToFetch);
        }, error -> {
            try {
                if (error instanceof SQLException && this.handleOall8Failure((SQLException)error)) {
                    error = null;
                }
                try {
                    this.handleOall8CompletionAlways(all8);
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
            }
            finally {
                callback.accept((Throwable)error);
            }
        });
    }

    private int prepareForOALL8(boolean doFetch) throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "prepareForOALL8", "sqlKind={0}. ", (String)null, (Throwable)null, (Object)this.sqlKind);
            this.sqlKind = OracleStatement.SqlKind.OTHER;
        }
        int rowsToFetch = this.rowPrefetch;
        if (doFetch) {
            if (this.autoTuneRowPrefetch && this.sqlKind == OracleStatement.SqlKind.SELECT) {
                this.tuneRowPrefetch();
            }
            this.rowPrefetchInLastFetch = rowsToFetch = this.getMaximumRowFetchForOALL8();
            if (rowsToFetch == 0 && this.isAllFetched) {
                return -1;
            }
            this.rowData.setPosition(this.beyondRowData);
        }
        if (this.fetchMode == OracleStatement.FetchMode.OVERWRITE) {
            this.prepareAccessorRowCountsForOALL8(0);
        }
        this.prepareBindsByteArrayForOALL8();
        this.allocateTmpByteArray();
        return rowsToFetch;
    }

    private int getMaximumRowFetchForOALL8() {
        boolean limitFetchByMaxRows;
        long fetchedRowCount = this.indexOfFirstRow + (long)this.storedRowCount;
        boolean bl = limitFetchByMaxRows = this.maxRows > 0L && this.maxRows <= fetchedRowCount + (long)this.rowPrefetch;
        if (limitFetchByMaxRows) {
            this.isAllFetched = true;
            return (int)(this.maxRows - fetchedRowCount);
        }
        return this.rowPrefetch;
    }

    private void prepareAccessorRowCountsForOALL8(int fetchedRowCount) {
        int i;
        if (this.accessors != null) {
            for (i = 0; i < this.accessors.length; ++i) {
                if (this.accessors[i] == null) continue;
                this.accessors[i].lastRowProcessed = fetchedRowCount;
            }
        }
        if (this.outBindAccessors != null) {
            for (i = 0; i < this.outBindAccessors.length; ++i) {
                if (this.outBindAccessors[i] == null) continue;
                this.outBindAccessors[i].lastRowProcessed = 0;
            }
        }
    }

    private void prepareBindsByteArrayForOALL8() {
        if (this.bindIndicators != null) {
            int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int maxNbBytes = 0;
            if (this.ibtBindChars != null) {
                maxNbBytes = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int P = 0; P < this.numberOfBindPositions; ++P) {
                int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
                int charPitch = this.bindIndicators[subRangeOffset + 2] & 0xFFFF;
                if (charPitch == 0) continue;
                int formOfUse = this.bindIndicators[subRangeOffset + 9] & 0xFFFF;
                if (this.bindUseDBA) continue;
                maxNbBytes = formOfUse == 2 ? Math.max(charPitch * this.connection.conversion.maxNCharSize, maxNbBytes) : Math.max(charPitch * this.connection.conversion.cMaxCharSize, maxNbBytes);
            }
            if (!this.bindUseDBA) {
                if (this.tmpBindsByteArray == null) {
                    this.tmpBindsByteArray = new byte[maxNbBytes];
                } else if (this.tmpBindsByteArray.length < maxNbBytes) {
                    this.tmpBindsByteArray = null;
                    this.tmpBindsByteArray = new byte[maxNbBytes];
                }
            }
        } else {
            this.tmpBindsByteArray = null;
        }
    }

    private void initializeOall8(T4C8Oall all8, boolean isRowIdPrefixed, int rowsToFetch) throws SQLException {
        all8.typeOfStatement = this.sqlKind;
        all8.cursor = this.getCursorId();
        all8.sqlStmt = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        all8.rowsToFetch = rowsToFetch;
        all8.outBindAccessors = this.outBindAccessors;
        all8.numberOfBindPositions = this.numberOfBindPositions;
        all8.definesAccessors = this.accessors;
        all8.definesLength = this.getNumberOfDefinePositionsForOALL8();
        all8.bindBytes = this.bindBytes;
        all8.bindChars = this.bindChars;
        all8.bindIndicators = this.bindIndicators;
        all8.bindIndicatorSubRange = this.bindIndicatorSubRange;
        all8.conversion = this.connection.conversion;
        all8.tmpBindsByteArray = this.tmpBindsByteArray;
        all8.parameterStream = this.parameterStream;
        all8.oracleStatement = this;
        all8.ibtBindBytes = this.ibtBindBytes;
        all8.ibtBindChars = this.ibtBindChars;
        all8.ibtBindIndicators = this.ibtBindIndicators;
        all8.oacdefBindsSent = this.oacdefSent;
        all8.definedColumnType = this.getDefinedColumnTypesForOALL8(isRowIdPrefixed);
        all8.definedColumnSize = this.getDefinedColumnSizesForOALL8(isRowIdPrefixed);
        all8.definedColumnFormOfUse = this.getDefinedColumnFormsOfUseForOALL8(isRowIdPrefixed);
        all8.registration = this.registration;
        all8.bindData = this.bindData;
        all8.bindDataOffsets = this.bindDataOffsets;
        all8.bindDataLengths = this.bindDataLengths;
        all8.bindUseDBA = this.bindUseDBA;
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, this.CLASS_NAME, "initializeOall8", "cursorId={0}", (String)null, null, (Object)this.getCursorId());
    }

    private int getNumberOfDefinePositionsForOALL8() {
        if (this.sqlKind.isDML()) {
            return 0;
        }
        return this.numberOfDefinePositions;
    }

    private int[] getDefinedColumnTypesForOALL8(boolean isRowIdPrefixed) {
        if (isRowIdPrefixed) {
            int[] definedColumnTypeCopy = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, definedColumnTypeCopy, 1, this.definedColumnType.length);
            definedColumnTypeCopy[0] = -8;
            return definedColumnTypeCopy;
        }
        return this.definedColumnType;
    }

    private int[] getDefinedColumnSizesForOALL8(boolean isRowIdPrefixed) {
        if (isRowIdPrefixed) {
            int[] definedColumnSizeCopy = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, definedColumnSizeCopy, 1, this.definedColumnSize.length);
            return definedColumnSizeCopy;
        }
        return this.definedColumnSize;
    }

    private int[] getDefinedColumnFormsOfUseForOALL8(boolean isRowIdPrefixed) {
        if (isRowIdPrefixed) {
            int[] definedColumnFormOfUseCopy = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, definedColumnFormOfUseCopy, 1, this.definedColumnFormOfUse.length);
            return definedColumnFormOfUseCopy;
        }
        return this.definedColumnFormOfUse;
    }

    private boolean handleOall8Failure(SQLException sqlException) {
        if (DatabaseError.isInternallyHandledWarning(sqlException)) {
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            return true;
        }
        return false;
    }

    private void handleOall8CompletionAlways(T4C8Oall all8) throws SQLException {
        int tmpCursorID = all8.getCursorId();
        if (tmpCursorID != 0) {
            this.setCursorId(tmpCursorID);
        }
        this.oacdefSent = all8.oacdefBindsSent;
        if (this.connection.isPDBChanged) {
            this.connection.onPDBChange(this);
            this.connection.isPDBChanged = false;
        }
        this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
        this.updateStreamingOAll(all8);
    }

    @Override
    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "allocateTmpByteArray", "allocate byte array of size={0}. ", (String)null, (Throwable)null, (Object)this.sizeTmpByteArray);
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "allocateTmpByteArray", "Re-allocate byte array of size={0}. ", (String)null, (Throwable)null, (Object)this.sizeTmpByteArray);
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "allocateTmpByteArray", "do not re-allocate byte array of size={0}, current size={1}. ", (String)null, (Throwable)null, (Object)this.sizeTmpByteArray, (Object)this.tmpByteArray.length);
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        if (!(this.t4Connection == null || this.wrapper != null && this.wrapper.isExecutingAsync())) {
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
        }
    }

    @Override
    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor((OracleStatement)this, 128, 1, -8, false, this.t4Connection.mare);
    }

    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    @Override
    protected void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        if (this.connection.disableDefinecolumntype) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "defineColumnTypeInternal", "defineColumnTypeInternal is DISABLED. ", null, null);
            return;
        }
        if (type == -15 || type == -9 || type == -16) {
            form = (short)2;
        }
        if (column_index < 1) {
            throw (SQLException)DatabaseError.createSqlException(3).fillInStackTrace();
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            throw (SQLException)DatabaseError.createSqlException(28).fillInStackTrace();
        }
        int idx = column_index - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= idx) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(idx + 1) * 4];
            } else {
                int[] n_definedColumnType = new int[(idx + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, n_definedColumnType, 0, this.definedColumnType.length);
                this.definedColumnType = n_definedColumnType;
            }
        }
        this.definedColumnType[idx] = type;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= idx) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(idx + 1) * 4];
            } else {
                int[] n_definedColumnSize = new int[(idx + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, n_definedColumnSize, 0, this.definedColumnSize.length);
                this.definedColumnSize = n_definedColumnSize;
            }
        }
        switch (type) {
            case 2004: 
            case 2005: {
                this.definedColumnSize[idx] = sizeNotGiven ? 0 : size;
                break;
            }
            default: {
                this.definedColumnSize[idx] = -1;
            }
        }
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= idx) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(idx + 1) * 4];
            } else {
                int[] n_definedColumnFormOfUse = new int[(idx + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, n_definedColumnFormOfUse, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = n_definedColumnFormOfUse;
            }
        }
        this.definedColumnFormOfUse[idx] = form;
        this.executeDoneForDefines = false;
    }

    @Override
    public void clearDefines() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doClearDefines();
        }
    }

    @Override
    protected void doClearDefines() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        super.doClearDefines();
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (!(this.t4Connection == null || this.wrapper != null && this.wrapper.isExecutingAsync())) {
            this.t4Connection.all8.definesAccessors = null;
        }
    }

    @Override
    void doSetSnapshotSCN(long scn) throws SQLException {
        this.inScn = scn;
    }

    @Override
    protected ByteArray createBindData() {
        this.bindUseDBA = this.connection.bindUseDBA;
        return super.createBindData();
    }

    @Override
    protected final void locationToPutBytes(Accessor acc, int row, int length) throws SQLException {
        acc.setOffset(row, this.allocateRowDataSpace(length));
    }

    @Override
    long allocateRowDataSpace(int size) {
        long offset = this.beyondRowData;
        this.beyondRowData += (long)size;
        return offset;
    }

    @Override
    boolean areOutBindsStoredInBindData() {
        return false;
    }

    @Override
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean isOutBind) throws SQLException {
        Accessor result = null;
        switch (internal_type) {
            case 96: {
                result = new T4CCharAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!isOutBind) {
                    result = new T4CLongAccessor((OracleStatement)this, col_index, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                result = new T4CVarcharAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 2: {
                result = new T4CNumberAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 6: {
                result = new T4CVarnumAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 252: {
                result = new T4CBooleanAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!isOutBind) {
                    result = new T4CLongRawAccessor((OracleStatement)this, col_index, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (isOutBind) {
                    result = new T4COutRawAccessor(this, max_len, form, external_type, this.t4Connection.mare);
                    break;
                }
                result = new T4CRawAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 100: {
                result = new T4CBinaryFloatAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 101: {
                result = new T4CBinaryDoubleAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 104: 
            case 208: {
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK || this.sqlObject.returningIntoParameterCount > 0) {
                    result = new T4CVarcharAccessor((OracleStatement)this, 18, form, external_type, isOutBind, this.t4Connection.mare);
                    result.definedColumnType = -8;
                    break;
                }
                result = new T4CRowidAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 102: {
                result = new T4CResultSetAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 12: {
                result = new T4CDateAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 113: {
                result = new T4CBlobAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 119: {
                result = new T4CJsonAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 112: {
                result = new T4CClobAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 114: {
                result = new T4CBfileAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 109: {
                result = new T4CNamedTypeAccessor((OracleStatement)this, typeName, form, external_type, isOutBind, this.t4Connection.mare);
                result.initMetadata();
                break;
            }
            case 111: {
                result = new T4CRefTypeAccessor((OracleStatement)this, typeName, form, external_type, isOutBind, this.t4Connection.mare);
                result.initMetadata();
                break;
            }
            case 180: {
                result = new T4CTimestampAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 181: {
                result = new T4CTimestamptzAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 231: {
                result = new T4CTimestampltzAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 182: {
                result = new T4CIntervalymAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 183: {
                result = new T4CIntervaldsAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 127: {
                result = new T4CVectorAccessor((OracleStatement)this, max_len, form, external_type, isOutBind, this.t4Connection.mare);
                break;
            }
            case 995: {
                throw (SQLException)DatabaseError.createSqlException(89).fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(col_index + 1)).fillInStackTrace();
            }
        }
        return result;
    }

    @Override
    void doDescribe(boolean includeNames) throws SQLException {
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
        byte[] sqlBytes = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        try {
            this.t4Connection.needLine();
            this.t4Connection.describe.doODNY(this, 0, this.accessors, sqlBytes);
            this.accessors = this.t4Connection.describe.getAccessors();
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            for (int i = 0; i < this.numberOfDefinePositions; ++i) {
                this.accessors[i].initMetadata();
            }
        }
        catch (IOException ex) {
            ((T4CConnection)this.connection).handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(ex).fillInStackTrace();
        }
        this.describedWithNames = true;
        this.described = true;
    }

    @Override
    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.execute_for_describe");
        T4C8Oall all8 = this.t4Connection.all8;
        try {
            this.doOall8(all8, true, true, this.definedColumnType != null, true, this.definedColumnType != null);
        }
        catch (SQLException e) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "executeForDescribe", null, null, e);
            throw e;
        }
        catch (IOException e) {
            ((T4CConnection)this.connection).handleIOException(e);
            throw (SQLException)DatabaseError.createSqlException(e).fillInStackTrace();
        }
        finally {
            this.updateAfterDescribeAlways(all8);
        }
        this.updateAfterDescribeWithoutError(all8);
        for (int i = 0; i < this.numberOfDefinePositions; ++i) {
            this.accessors[i].initMetadata();
        }
        this.needToPrepareDefineBuffer = false;
    }

    @Override
    final void executeForDescribeAsync(Consumer<Throwable> callback) {
        try {
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
        }
        T4C8Oall all8 = new T4C8Oall(this.t4Connection);
        this.doOall8Async(all8, true, true, this.definedColumnType != null, true, this.definedColumnType != null, error -> {
            try {
                if (error instanceof IOException) {
                    IOException ioE = (IOException)error;
                    ((T4CConnection)this.connection).handleIOException(ioE);
                    error = DatabaseError.createSqlException(ioE).fillInStackTrace();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                this.updateAfterDescribeAlways(all8);
                if (error == null) {
                    this.updateAfterDescribeWithoutError(all8);
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            if (error == null) {
                CompletionStage<Void> metaDataStage = this.initAccessorMetadataAsync();
                if (metaDataStage == CompletionStageUtil.VOID_COMPLETED_FUTURE) {
                    this.needToPrepareDefineBuffer = false;
                    callback.accept(null);
                } else {
                    metaDataStage.whenComplete((nil, metaDataError) -> {
                        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                            this.needToPrepareDefineBuffer = false;
                            callback.accept((Throwable)metaDataError);
                        }
                    });
                }
            } else {
                callback.accept((Throwable)error);
            }
        });
    }

    private CompletionStage<Void> initAccessorMetadataAsync() {
        CompletionStage<Void> initMetadataStage = CompletionStageUtil.VOID_COMPLETED_FUTURE;
        for (int i = 0; i < this.numberOfDefinePositions; ++i) {
            if (initMetadataStage.toCompletableFuture().isDone()) {
                initMetadataStage = this.accessors[i].initMetadataAsync();
                continue;
            }
            Accessor accessor = this.accessors[i];
            initMetadataStage = initMetadataStage.thenCompose(nil2 -> accessor.initMetadataAsync());
        }
        if (initMetadataStage.toCompletableFuture().isDone()) {
            this.needToPrepareDefineBuffer = false;
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        return initMetadataStage.thenRun(() -> {
            this.needToPrepareDefineBuffer = false;
        });
    }

    private void updateAfterDescribeAlways(T4C8Oall all8) throws SQLException {
        this.rowsProcessed = all8.rowsProcessed;
        this.validRows = all8.getNumRows();
        if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
            if (this.validRows > 0L) {
                this.calculateCheckSum();
            } else if (this.rowsProcessed > 0L) {
                long _checkSum;
                this.checkSum = _checkSum = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
            }
        }
    }

    private void updateAfterDescribeWithoutError(T4C8Oall all8) throws SQLException {
        this.needToParse = false;
        if (this.definedColumnType == null) {
            this.implicitDefineForLobPrefetchDone = false;
        }
        this.aFetchWasDoneDuringDescribe = false;
        if (all8.aFetchWasDone) {
            this.aFetchWasDoneDuringDescribe = true;
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean isDescribed) throws SQLException {
        try {
            T4C8Oall all8 = this.t4Connection.all8;
            try {
                boolean sendDefine = this.prepareForExecuteForRows();
                this.doOall8(all8, this.needToParse, !isDescribed, true, false, sendDefine);
                this.handleExecuteForRowsCompletion(sendDefine);
            }
            finally {
                this.handleExecuteForRowsCompletionAlways(all8);
            }
        }
        catch (IOException e) {
            ((T4CConnection)this.connection).handleIOException(e);
            throw (SQLException)DatabaseError.createSqlException(e).fillInStackTrace();
        }
    }

    @Override
    void executeForRowsAsync(boolean isDescribed, Consumer<Throwable> callback) {
        boolean sendDefine;
        try {
            sendDefine = this.prepareForExecuteForRows();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        T4C8Oall all8 = new T4C8Oall(this.t4Connection);
        this.doOall8Async(all8, this.needToParse, !isDescribed, true, false, sendDefine, error -> {
            try {
                if (error == null) {
                    this.handleExecuteForRowsCompletion(sendDefine);
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                this.handleExecuteForRowsCompletionAlways(all8);
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                if (error instanceof IOException) {
                    IOException ioE = (IOException)error;
                    ((T4CConnection)this.connection).handleIOException(ioE);
                    error = DatabaseError.createSqlException(ioE).fillInStackTrace();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        });
    }

    private boolean prepareForExecuteForRows() throws SQLException {
        if (this.columnsDefinedByUser) {
            this.needToPrepareDefineBuffer = false;
            return false;
        }
        return this.prepareLobDefinesForExecution();
    }

    private void handleExecuteForRowsCompletionAlways(T4C8Oall all8) throws SQLException {
        this.validRows = this.implicitResultSetStatements == null ? all8.getNumRows() : 0L;
        this.calculateCheckSum();
    }

    private void handleExecuteForRowsCompletion(boolean sentDefine) {
        this.needToParse = false;
        if (sentDefine) {
            this.implicitDefineForLobPrefetchDone = true;
        }
    }

    private boolean prepareLobDefinesForExecution() throws SQLException {
        if ((!this.t4Connection.useLobPrefetch || this.accessors == null || this.defaultLobPrefetchSize == -1 || this.implicitDefineForLobPrefetchDone || this.aFetchWasDoneDuringDescribe || this.definedColumnType != null) && !this.isFetchingValueBasedLob) {
            return false;
        }
        boolean oneColumnIsALob = false;
        int[] tempDefinedColumnType = new int[this.accessors.length];
        int[] tempDefinedColumnSize = new int[this.accessors.length];
        int[] tempDefinedColumnFormOfUse = new int[this.accessors.length];
        for (int i = 0; i < this.accessors.length; ++i) {
            if (this.accessors[i] == null) continue;
            tempDefinedColumnType[i] = this.getJDBCType(this.accessors[i].internalType);
            tempDefinedColumnFormOfUse[i] = this.accessors[i].formOfUse;
            if (this.accessors[i].internalType == 113 || this.accessors[i].internalType == 112 || this.accessors[i].internalType == 114) {
                oneColumnIsALob = true;
                this.accessors[i].setPrefetchLength(this.defaultLobPrefetchSize);
                tempDefinedColumnSize[i] = this.defaultLobPrefetchSize;
                continue;
            }
            if (this.accessors[i].internalType == 119) {
                oneColumnIsALob = true;
                this.accessors[i].setPrefetchLength(0x2000000);
                tempDefinedColumnSize[i] = 0x2000000;
                continue;
            }
            if (this.accessors[i].internalType != 127) continue;
            oneColumnIsALob = true;
            this.accessors[i].setPrefetchLength(524308);
            tempDefinedColumnSize[i] = 524308;
        }
        if (oneColumnIsALob) {
            this.definedColumnType = tempDefinedColumnType;
            this.definedColumnSize = tempDefinedColumnSize;
            this.definedColumnFormOfUse = tempDefinedColumnFormOfUse;
            return true;
        }
        return false;
    }

    @Override
    protected void fetch(int firstRow) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, this.CLASS_NAME, "fetch", "firstRow={0}, fetchMode={1}.", (String)null, (Throwable)null, (Object)firstRow, (Object)this.fetchMode);
        this.prepareForFetch(firstRow);
        boolean sendDefine = this.prepareLobDefinesForExecution();
        try {
            T4C8Oall all8 = this.t4Connection.all8;
            this.doOall8(all8, false, false, true, false, sendDefine);
            this.handleFetchCompletion(all8, sendDefine, firstRow);
        }
        catch (IOException ex) {
            ((T4CConnection)this.connection).handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(ex).fillInStackTrace();
        }
    }

    @Override
    protected final void fetchAsync(int firstRow, Consumer<Throwable> callback) {
        boolean sendDefine;
        try {
            this.prepareForFetch(firstRow);
            this.releaseStreamsBeforeFetch();
            sendDefine = this.prepareLobDefinesForExecution();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        T4C8Oall all8 = new T4C8Oall(this.t4Connection);
        this.doOall8Async(all8, false, false, true, false, sendDefine, error -> {
            try {
                if (error == null) {
                    this.handleFetchCompletion(all8, sendDefine, firstRow);
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                if (error instanceof IOException) {
                    IOException ioEx = (IOException)error;
                    ((T4CConnection)this.connection).handleIOException(ioEx);
                    error = (SQLException)DatabaseError.createSqlException(ioEx).fillInStackTrace();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        });
    }

    @Override
    final boolean isFetchAsyncSupported() {
        return true;
    }

    private void prepareForFetch(int firstRow) throws SQLException {
        if (this.fetchMode == OracleStatement.FetchMode.APPEND) {
            this.prepareAccessorRowCountsForOALL8(firstRow);
        } else if (this.rowData != null) {
            this.beyondRowData = 0L;
        }
        this.releaseStreamsBeforeFetch();
    }

    private void releaseStreamsBeforeFetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    ((T4CConnection)this.connection).handleIOException(exc);
                    throw (SQLException)DatabaseError.createSqlException(exc).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    private void handleFetchCompletion(T4C8Oall all8, boolean sentDefine, int firstRow) throws SQLException {
        if (sentDefine) {
            this.implicitDefineForLobPrefetchDone = true;
        }
        this.validRows = all8.getNumRows();
        if (this.validRows != -2L) {
            this.validRows -= (long)firstRow;
        }
        this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
        this.calculateCheckSum();
    }

    @Override
    void continueReadRow(int start) throws SQLException {
        if (this.streamingOAll == null) {
            return;
        }
        try {
            this.streamingOAll.continueReadRow(start, this);
            this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
            this.updateStreamingOAll(this.streamingOAll);
        }
        catch (IOException ioException) {
            ((T4CConnection)this.connection).handleIOException(ioException);
            throw (SQLException)DatabaseError.createSqlException(ioException).fillInStackTrace();
        }
        catch (SQLException sqlException) {
            if (DatabaseError.isInternallyHandledWarning(sqlException)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sqlException;
        }
    }

    private void updateStreamingOAll(T4C8Oall oall) {
        this.streamingOAll = oall.getNumRows() == -2L ? oall : null;
    }

    @Override
    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.do_close");
        int cursorId = this.getCursorId();
        if (cursorId != 0) {
            this.t4Connection.closeCursor(cursorId);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    @Override
    void closeQuery() throws SQLException {
        this.connection.needLine();
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    ((T4CConnection)this.connection).handleIOException(exc);
                    throw (SQLException)DatabaseError.createSqlException(exc).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        int cursorId = this.getCursorId();
        if (!this.isAllFetched && cursorId != 0) {
            this.t4Connection.closeQuery(cursorId);
        }
    }

    @Override
    Binder getRowidNullBinder(int index) throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            this.currentRowCharLens[index] = 1;
            return new VarcharNullBinder();
        }
        return this.createRowidNullBinder();
    }

    @Override
    protected void doBindValueConversion(int bindersOffset) throws SQLException {
        this.doBindValueConversion(bindersOffset, 1);
    }

    @Override
    protected void reallocBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        if (this.bindIndicators == null) {
            this.allocBinds(1);
        }
    }

    @Override
    protected int getAllocBindsRowCount() {
        return 1;
    }

    @Override
    protected void executeBatchFromQueueAsync(BiConsumer<long[], Throwable> callback) {
        AtomicInteger bufferScope = new AtomicInteger(0);
        Pipeline pipeline = this.t4Connection.pipeline();
        super.executeBatchFromQueueAsync((batchResults, error) -> {
            try {
                callback.accept((long[])batchResults, (Throwable)error);
            }
            finally {
                if (bufferScope.getAndDecrement() == 1) {
                    pipeline.endBuffer();
                }
            }
        });
        if (bufferScope.getAndIncrement() == 0) {
            pipeline.beginBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeEnqueuedBatchAsync(long[] batchResults, int callResultIndex, long totalValidRows, SQLException continueOnFailureException, BiConsumer<Long, Throwable> callback) {
        boolean isFirstOALL8;
        Pipeline pipeline = this.t4Connection.pipeline();
        boolean bl = isFirstOALL8 = callResultIndex == 0;
        if (!isFirstOALL8) {
            pipeline.beginBufferSuspend();
        }
        try {
            super.executeEnqueuedBatchAsync(batchResults, callResultIndex, totalValidRows, continueOnFailureException, callback);
        }
        finally {
            if (!isFirstOALL8) {
                pipeline.endBufferSuspend();
            }
        }
    }

    private void setupBindBuffers() throws SQLException {
        if (this.currentRank > 1 || this.numberOfBindPositions != 0) {
            this.setupBindBuffers(this.firstRowInBatch, this.currentRank == 0 ? 1 : this.currentRank);
        }
    }

    @Override
    Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo ibtBindInfo, short form) throws SQLException {
        return new T4CPlsqlIndexTableAccessor(this, ibtBindInfo, form, this.t4Connection.mare);
    }

    @Override
    void endOfResultSet() throws SQLException {
        super.endOfResultSet();
        this.freeRowData();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ea) {
                return null;
            }
        } else {
            this.md.reset();
        }
        if (this.maxRows > 0L) {
            return null;
        }
        for (String s : this.nlsStrings) {
            String property = (String)this.connection.sessionProperties.get(s);
            if (property == null) continue;
            this.md.update(property.getBytes(StandardCharsets.UTF_16));
        }
        if (this.t4Connection.currentSchema != null) {
            this.md.update(this.t4Connection.currentSchema.getBytes(StandardCharsets.UTF_16));
        }
        if (this.currentRowBinders != null) {
            for (Binder b : this.lastBinders) {
                switch (b.type) {
                    case 8: 
                    case 24: 
                    case 109: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: {
                        return null;
                    }
                }
                this.md.update((byte)(b.type & 0xFF));
                this.md.update((byte)(b.type >> 8 & 0xFF));
            }
            if (this.bindUseDBA) {
                if (this.numberOfBindPositions > 0 && this.bindDataOffsets != null && this.bindDataLengths != null && this.bindIndicators != null) {
                    int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
                    for (int rowIndex = 0; rowIndex < number_of_bound_rows; ++rowIndex) {
                        int rowStartPosition = rowIndex * this.numberOfBindPositions;
                        for (int position = 0; position < this.numberOfBindPositions; ++position) {
                            int bindDataIndex = rowStartPosition + position;
                            this.bindData.updateDigest(this.md, this.bindDataOffsets[bindDataIndex], this.bindDataLengths[bindDataIndex]);
                        }
                    }
                }
            } else if (this.bindBytes != null) {
                this.md.update(this.bindBytes, 0, this.totalBindByteLength);
            } else if (this.bindDataLengths != null) {
                long localBindChecksum = 0L;
                long offset = this.bindDataOffsets[0];
                int length = (int)(offset - this.bindDataOffsets[this.bindDataOffsets.length - 1]) + this.bindDataLengths[this.bindDataLengths.length - 1];
                localBindChecksum = this.bindData.updateChecksum(offset, length, PhysicalConnection.CHECKSUM, localBindChecksum);
                this.md.update(String.valueOf(localBindChecksum).getBytes(StandardCharsets.UTF_16));
            }
            int temp3 = Arrays.hashCode(this.bindIndicators);
            byte[] b = this.t4Connection.mare.tmpBuffer4;
            int i = 0;
            int exp = 8 * (b.length - 1);
            while (i < b.length) {
                b[i] = (byte)((temp3 & 255 << exp) >> exp);
                ++i;
                exp -= 8;
            }
            this.md.update(b);
            if (this.bindChars != null) {
                long temp4 = CRC64.updateChecksum(0L, this.bindChars, 0, this.totalBindCharLength);
                b = this.t4Connection.mare.tmpBuffer8;
                int i2 = 0;
                int exp2 = 8 * (b.length - 1);
                while (i2 < b.length) {
                    long mask = 255L << exp2;
                    b[i2] = (byte)((temp4 & mask) >> exp2);
                    ++i2;
                    exp2 -= 8;
                }
                this.md.update(b);
            }
        }
        this.runtimeKey = this.md.digest();
        return this.runtimeKey;
    }

    @Override
    Object[] handleOtherPlsqlTypes(int internalType, Object arrayData, int curLen, int[] eMaxLen) throws SQLException {
        Datum[] returnValue = null;
        switch (internalType) {
            case 12: {
                OracleTypeDATE typeObj = new OracleTypeDATE();
                returnValue = typeObj.toDatumArray(arrayData, this.connection, 1L, curLen);
                if (returnValue == null) break;
                eMaxLen[0] = 8;
                break;
            }
            case 180: {
                OracleTypeTIMESTAMP typeObj = new OracleTypeTIMESTAMP(this.connection);
                returnValue = typeObj.toDatumArray(arrayData, this.connection, 1L, curLen);
                if (returnValue == null) break;
                eMaxLen[0] = 8;
            }
        }
        return returnValue;
    }

    @Override
    protected final void prepareForExecuteWithDRCP() throws SQLException {
        int cursorId = this.getCursorId();
        if (cursorId != 0 && !this.t4Connection.canSendCursorIds()) {
            this.t4Connection.closeCursor(cursorId);
            this.clearCursorId();
        }
    }
}

