/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.List;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonValue;

public interface OracleJsonArray
extends OracleJsonStructure,
List<OracleJsonValue> {
    public String getString(int var1);

    public int getInt(int var1);

    public double getDouble(int var1);

    public BigDecimal getBigDecimal(int var1);

    public long getLong(int var1);

    public boolean getBoolean(int var1);

    public boolean isNull(int var1);

    public byte[] getBytes(int var1);

    public LocalDateTime getLocalDateTime(int var1);

    public OffsetDateTime getOffsetDateTime(int var1);

    default public OracleJsonObject getObject(int index) {
        return ((OracleJsonValue)this.get(index)).asJsonObject();
    }

    default public OracleJsonArray getArray(int index) {
        return ((OracleJsonValue)this.get(index)).asJsonArray();
    }

    @Override
    public OracleJsonValue set(int var1, String var2);

    @Override
    public OracleJsonValue set(int var1, int var2);

    @Override
    public OracleJsonValue set(int var1, double var2);

    @Override
    public OracleJsonValue set(int var1, long var2);

    @Override
    public OracleJsonValue set(int var1, BigDecimal var2) throws OracleJsonException;

    @Override
    public OracleJsonValue set(int var1, boolean var2);

    public OracleJsonValue setNull(int var1);

    @Override
    public OracleJsonValue set(int var1, LocalDateTime var2);

    @Override
    public OracleJsonValue set(int var1, OffsetDateTime var2);

    @Override
    public OracleJsonValue set(int var1, byte[] var2);

    public void add(String var1);

    public void add(int var1);

    public void add(double var1);

    public void add(long var1);

    public void add(BigDecimal var1);

    public void add(boolean var1);

    public void addNull();

    public void add(LocalDateTime var1);

    public void add(OffsetDateTime var1);

    public void add(byte[] var1);

    public <T extends OracleJsonValue> List<T> getValuesAs(Class<T> var1);
}

