/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.internal.Monitor;

public class ReplayLoggerFactory {
    private static final Logger logger = Logger.getLogger(ReplayLoggerFactory.class.getCanonicalName());
    private static final Monitor LOG_LEVEL_MONITOR = Monitor.newInstance();

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public static void setLogLevel(Level newLogLevel) {
        try (Monitor.CloseableLock lock = LOG_LEVEL_MONITOR.acquireCloseableLock();){
            try {
                Logger.getLogger("oracle.jdbc.internal.replay").setLevel(newLogLevel);
                if (newLogLevel != null) {
                    Handler[] logHandler = Logger.getLogger("").getHandlers();
                    for (int i = 0; i < logHandler.length; ++i) {
                        logHandler[i].setLevel(newLogLevel);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "setLogLevel", e);
            }
        }
    }

    public static Level getLogLevel() {
        return Logger.getLogger("oracle.jdbc.internal.replay").getLevel();
    }
}

