/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;

public class StatisticsTracker
implements Serializable {
    private static final String CLASS_NAME = StatisticsTracker.class.getName();
    private final Integer FIXED_VALUE = 1;
    private ConcurrentHashMap<oracle.jdbc.replay.internal.ReplayStatistics, Integer> acStatistics = new ConcurrentHashMap();
    private AtomicBoolean dsNameSet = new AtomicBoolean(false);
    private ReplayStatisticsImpl aggregateStats = new ReplayStatisticsImpl();
    private String dsName = null;

    public ReplayStatistics getReplayStatistics() {
        long totalRequests = 0L;
        long totalCompletedRequests = 0L;
        long totalCalls = 0L;
        long totalProtectedCalls = 0L;
        long totalCallsAffectedByOutages = 0L;
        long totalCallsTriggeringReplay = 0L;
        long totalCallsAffectedByOutagesDuringReplay = 0L;
        long successfulReplayCount = 0L;
        long failedReplayCount = 0L;
        long replayDisablingCount = 0L;
        long totalReplayAttempts = 0L;
        int[] histogram = new int[31];
        for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics.keySet()) {
            totalRequests += stats.getTotalRequests();
            totalCompletedRequests += stats.getTotalCompletedRequests();
            totalCalls += stats.getTotalCalls();
            totalProtectedCalls += stats.getTotalProtectedCalls();
            totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
            totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
            totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
            successfulReplayCount += stats.getSuccessfulReplayCount();
            failedReplayCount += stats.getFailedReplayCount();
            replayDisablingCount += stats.getReplayDisablingCount();
            totalReplayAttempts += stats.getTotalReplayAttempts();
            int[] h = stats.getRequestSizeHistogram();
            if (h == null || h.length <= 0) continue;
            for (int i = 0; i < h.length; ++i) {
                int n = i;
                histogram[n] = histogram[n] + h[i];
            }
        }
        ReplayStatisticsImpl globalStats = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts, 0);
        globalStats.setRequestSizeHistogram(histogram);
        globalStats.aggregate(this.aggregateStats);
        return globalStats;
    }

    public String getReplayStatisticsString() {
        ReplayStatisticsImpl globalStats = (ReplayStatisticsImpl)this.getReplayStatistics();
        StringBuilder builder = new StringBuilder();
        builder.append(globalStats.toString()).append("\n\n").append(globalStats.getRequestSizeHistogramString()).append("\n\n");
        return builder.toString();
    }

    public void clearReplayStatistics() {
        this.acStatistics = new ConcurrentHashMap();
        this.aggregateStats = new ReplayStatisticsImpl();
    }

    public void updateReplayStatistics(String dsName, oracle.jdbc.replay.internal.ReplayStatistics newStats) {
        if (this.dsNameSet.compareAndSet(false, true) && dsName != null) {
            this.dsName = dsName;
        }
        if (newStats != null) {
            this.acStatistics.put(newStats, this.FIXED_VALUE);
        }
    }

    public void removeReplayStatistics(final oracle.jdbc.replay.internal.ReplayStatistics stats) {
        try {
            OracleDriver.getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (stats != null) {
                            StatisticsTracker.this.acStatistics.remove(stats);
                        }
                        StatisticsTracker.this.aggregateStats.aggregate(stats);
                    }
                    catch (Throwable err) {
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "removeReplayStatistics", "Async AC statistics-removal task failed: {0}", (String)null, (Throwable)null, (Object)err);
                    }
                }
            });
        }
        catch (Throwable exc) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "removeReplayStatistics", "Async AC statistics-removal task submission failed: {0}", (String)null, (Throwable)null, (Object)exc);
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }
}

