/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.RowidBinder;

class LittleEndianRowidBinder
extends RowidBinder {
    private static final String CLASS_NAME = LittleEndianRowidBinder.class.getName();

    LittleEndianRowidBinder(byte[] val) {
        super(val);
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] value = this.paramVal;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            int l = value.length;
            bindIndicators[lenoffset] = (short)(l + 2);
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                bindDataLengths[bindDataIndex] = l + 2;
                stmt.lastBoundDataLengths[bindPosition] = l + 2;
                stmt.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "bind", "LittleEndingRowidBinder skipping length bytes. ", null, null);
                bindData.put(value);
            } else {
                bindBytes[byteoffset] = (byte)(l & 0xFF);
                bindBytes[byteoffset + 1] = (byte)(l >> 8);
                System.arraycopy(value, 0, bindBytes, byteoffset + 2, l);
            }
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value, 0, value.length);
        }
        return localCheckSum;
    }
}

