/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import jakarta.jms.JMSException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlRawMessage;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsBytesMessage;
import oracle.jakarta.jms.AQjmsMapMessage;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsObjectMessage;
import oracle.jakarta.jms.AQjmsSignature;
import oracle.jakarta.jms.AQjmsTextMessage;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AQxmlGenUtil {
    static Node msg_genXml(AQjmsMessage msg, Document doc, Node node, int msg_number) {
        Element messageNode = null;
        Element messageNumberNode = null;
        Text messageNumberText = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: msg_genXml", "entry");
        messageNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message");
        node.appendChild(messageNode);
        messageNumberNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_number");
        messageNode.appendChild(messageNumberNode);
        messageNumberText = doc.createTextNode(String.valueOf(msg_number));
        messageNumberNode.appendChild(messageNumberText);
        AQxmlGenUtil.gen_xml_message_header(msg, doc, messageNode);
        AQxmlGenUtil.gen_xml_message_signature(msg.getSignature(), doc, messageNode);
        return messageNode;
    }

    static void gen_xml_message_header(AQjmsMessage msg, Document doc, Node node) {
        Element msgHeaderNode = null;
        Element msgIdNode = null;
        Text msgIdText = null;
        Element corridNode = null;
        Text corridText = null;
        Element expNode = null;
        Text expText = null;
        Element delayNode = null;
        Text delayText = null;
        Element priorityNode = null;
        Text priorityText = null;
        Object delCountNode = null;
        Object delCountText = null;
        Object recptListNode = null;
        Object recptListText = null;
        Element msgStateNode = null;
        Text msgStateText = null;
        Element senderIdNode = null;
        Object senderIdText = null;
        Element excepQNode = null;
        Text excepQText = null;
        AQjmsAgent sender_id_agent = null;
        String msg_id = null;
        String corr_id = null;
        String exp = null;
        String delay = null;
        String priority = null;
        String msg_state = null;
        Object sender_id = null;
        String exception_queue = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: gen_xml_message_header", " entry");
        msgHeaderNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_header");
        node.appendChild(msgHeaderNode);
        try {
            msg_id = msg.getJMSMessageID();
            if (msg_id != null) {
                msgIdNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_id");
                msgHeaderNode.appendChild(msgIdNode);
                msgIdText = doc.createTextNode(msg_id.substring(3));
                msgIdNode.appendChild(msgIdText);
            }
            if ((corr_id = msg.getJMSCorrelationID()) != null) {
                corridNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "correlation");
                msgHeaderNode.appendChild(corridNode);
                corridText = doc.createTextNode(corr_id);
                corridNode.appendChild(corridText);
            }
            if ((exp = msg.getJMSExpiration() == 0L ? String.valueOf(-1) : String.valueOf(msg.getJMSExpiration() - msg.getJMSTimestamp())) != null) {
                expNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "expiration");
                msgHeaderNode.appendChild(expNode);
                expText = doc.createTextNode(exp);
                expNode.appendChild(expText);
            }
            if ((delay = String.valueOf(msg.getStringProperty("JMS_OracleDelay"))) != null) {
                delayNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "delay");
                msgHeaderNode.appendChild(delayNode);
                delayText = doc.createTextNode(delay);
                delayNode.appendChild(delayText);
            }
            priority = String.valueOf(msg.getJMSPriority());
            priorityNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "priority");
            msgHeaderNode.appendChild(priorityNode);
            priorityText = doc.createTextNode(priority);
            priorityNode.appendChild(priorityText);
            msg_state = msg.getStringProperty("JMSXState");
            if (msg_state != null) {
                msgStateNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_state");
                msgHeaderNode.appendChild(msgStateNode);
                msgStateText = doc.createTextNode(msg_state);
                msgStateNode.appendChild(msgStateText);
            }
            if ((sender_id_agent = msg.getSenderID()) != null) {
                senderIdNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "sender_id");
                msgHeaderNode.appendChild(senderIdNode);
                AQxmlGenUtil.genXml(sender_id_agent, doc, senderIdNode);
            }
            if ((exception_queue = msg.getStringProperty("JMS_OracleExcpQ")) != null) {
                excepQNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "exception_queue");
                msgHeaderNode.appendChild(excepQNode);
                excepQText = doc.createTextNode(exception_queue);
                excepQNode.appendChild(excepQText);
            }
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlGenUtil.gen_xml_message_header exception: ", (Exception)((Object)jms_ex));
        }
    }

    static void gen_xml_oracle_jms_properties(AQjmsMessage msg, Document doc, Node node) {
        Element oracleJmsPropNode = null;
        Element msgTypeNode = null;
        Text msgTypeText = null;
        Element replyToNode = null;
        Element userIdNode = null;
        Text userIdText = null;
        Element appIdNode = null;
        Text appIdText = null;
        Element groupIdNode = null;
        Text groupIdText = null;
        Element groupSeqNode = null;
        Text groupSeqText = null;
        Element timestampNode = null;
        Text timestampText = null;
        Element recvTimeStampNode = null;
        Text recvTimeStampText = null;
        AQjmsAgent replyToAgent = null;
        Object replyToAgentString = null;
        String jms_type = null;
        String user_id = null;
        String app_id = null;
        String group_id = null;
        String group_seq = null;
        String timestamp = null;
        String recvTimeStamp = null;
        SimpleDateFormat formatter = null;
        Date tstamp = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: gen_xml_oracle_jms_properties", "entry");
        oracleJmsPropNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "oracle_jms_properties");
        node.appendChild(oracleJmsPropNode);
        try {
            jms_type = msg.getJMSType();
            if (jms_type != null) {
                msgTypeNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "type");
                oracleJmsPropNode.appendChild(msgTypeNode);
                msgTypeText = doc.createTextNode(jms_type);
                msgTypeNode.appendChild(msgTypeText);
            }
            if ((replyToAgent = (AQjmsAgent)msg.getJMSReplyTo()) != null) {
                try {
                    if (!replyToAgent.getName().equals(" ") || replyToAgent.getAddress() != null) {
                        replyToNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "reply_to");
                        oracleJmsPropNode.appendChild(replyToNode);
                        AQxmlGenUtil.genXml(replyToAgent, doc, replyToNode);
                    }
                }
                catch (SQLException sql_ex) {
                    AQxmlDebug.traceEx(3, "AQxmlGenUtil: gen_xml_oracle_jms_properties - sql_ex", sql_ex);
                }
            }
            if ((user_id = msg.getStringProperty("JMSXUserID")) != null) {
                userIdNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "userid");
                oracleJmsPropNode.appendChild(userIdNode);
                userIdText = doc.createTextNode(user_id);
                userIdNode.appendChild(userIdText);
            }
            if ((app_id = msg.getStringProperty("JMSXAppID")) != null) {
                appIdNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "appid");
                oracleJmsPropNode.appendChild(appIdNode);
                appIdText = doc.createTextNode(app_id);
                appIdNode.appendChild(appIdText);
            }
            if ((group_id = msg.getStringProperty("JMSXGroupID")) != null) {
                groupIdNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "groupid");
                oracleJmsPropNode.appendChild(groupIdNode);
                groupIdText = doc.createTextNode(group_id);
                groupIdNode.appendChild(groupIdText);
            }
            if ((group_seq = msg.getStringProperty("JMSXGroupSeq")) != null) {
                groupSeqNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "group_sequence");
                oracleJmsPropNode.appendChild(groupSeqNode);
                groupSeqText = doc.createTextNode(group_seq);
                groupSeqNode.appendChild(groupSeqText);
            }
            formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            AQxmlDebug.println("JMS timestamp: " + msg.getJMSTimestamp());
            tstamp = new Date(msg.getJMSTimestamp());
            timestamp = formatter.format(tstamp);
            if (timestamp != null) {
                timestampNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "timestamp");
                oracleJmsPropNode.appendChild(timestampNode);
                timestampText = doc.createTextNode(timestamp);
                timestampNode.appendChild(timestampText);
            }
            if ((recvTimeStamp = msg.getStringProperty("JMSXRcvTimestamp")) != null) {
                AQxmlDebug.println("JMS recv timestamp: " + msg.getLongProperty("JMSXRcvTimestamp"));
                tstamp = new Date(msg.getLongProperty("JMSXRcvTimestamp"));
                recvTimeStamp = formatter.format(tstamp);
                recvTimeStampNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "recv_timestamp");
                oracleJmsPropNode.appendChild(recvTimeStampNode);
                recvTimeStampText = doc.createTextNode(recvTimeStamp);
                recvTimeStampNode.appendChild(recvTimeStampText);
            }
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.println("JMS Exception in oracle jms properties");
            AQxmlDebug.traceEx(3, "AQxmlGenUtil: gen_xml_oracle_jms_properties", (Exception)((Object)jms_ex));
        }
    }

    static void gen_xml_user_properties(AQjmsMessage msg, Document doc, Node node) {
        Element userPropNode = null;
        Element propNode = null;
        Object propAttr = null;
        Element nameNode = null;
        Text nameText = null;
        Element valueNode = null;
        Text valueText = null;
        Enumeration my_enum = null;
        Object value = null;
        Object valueAttr = null;
        String name = null;
        Object msg_properties = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: gen_xml_user_properties", "entry");
        try {
            my_enum = msg.getUserPropertyNames();
            while (my_enum.hasMoreElements()) {
                if (userPropNode == null) {
                    userPropNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "user_properties");
                    node.appendChild(userPropNode);
                }
                propNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "property");
                userPropNode.appendChild(propNode);
                nameNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "name");
                propNode.appendChild(nameNode);
                name = (String)my_enum.nextElement();
                nameText = doc.createTextNode(name);
                nameNode.appendChild(nameText);
                value = msg.getObjectProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "string_value");
                    } else if (value instanceof Integer) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "int_value");
                    } else if (value instanceof Long) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "long_value");
                    } else if (value instanceof Double) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "double_value");
                    } else if (value instanceof Boolean) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "boolean_value");
                    } else if (value instanceof Float) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "float_value");
                    } else if (value instanceof Short) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "short_value");
                    } else if (value instanceof Byte) {
                        valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "byte_value");
                    }
                    propNode.appendChild(valueNode);
                    valueText = doc.createTextNode(value.toString());
                    valueNode.appendChild(valueText);
                    continue;
                }
                valueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "string_value");
                propNode.appendChild(valueNode);
            }
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlGenUtil: gen_xml_user_properties", (Exception)((Object)jms_ex));
        }
    }

    static void genXmlJmsBytesMessage(Object msg, Document doc, Node node, int msg_number) {
        Element payloadNode = null;
        Element bytesMessageNode = null;
        Object bytesMessageText = null;
        Node msgNode = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlJmsBytesMessage:", " entry");
        msgNode = AQxmlGenUtil.msg_genXml((AQjmsMessage)msg, doc, node, msg_number);
        payloadNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_payload");
        msgNode.appendChild(payloadNode);
        bytesMessageNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "jms_bytes_message");
        payloadNode.appendChild(bytesMessageNode);
        AQxmlGenUtil.gen_xml_oracle_jms_properties((AQjmsMessage)msg, doc, bytesMessageNode);
        AQxmlGenUtil.gen_xml_user_properties((AQjmsMessage)msg, doc, bytesMessageNode);
        AQxmlGenUtil.genXmlBytesPayload((AQjmsBytesMessage)msg, doc, bytesMessageNode);
    }

    static void genXmlJmsObjectMessage(Object msg, Document doc, Node node, int msg_number) {
        Element payloadNode = null;
        Element objectMessageNode = null;
        Object objectMessageText = null;
        Node msgNode = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlJmsObjectMessage:", " entry");
        msgNode = AQxmlGenUtil.msg_genXml((AQjmsMessage)msg, doc, node, msg_number);
        payloadNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_payload");
        msgNode.appendChild(payloadNode);
        objectMessageNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "jms_object_message");
        payloadNode.appendChild(objectMessageNode);
        AQxmlGenUtil.gen_xml_oracle_jms_properties((AQjmsMessage)msg, doc, objectMessageNode);
        AQxmlGenUtil.gen_xml_user_properties((AQjmsMessage)msg, doc, objectMessageNode);
        AQxmlGenUtil.genXmlObjectPayload((AQjmsObjectMessage)msg, doc, objectMessageNode);
    }

    static void genXmlJmsMapMessage(Object msg, Document doc, Node node, int msg_number) {
        Element payload_node = null;
        Element map_message_node = null;
        Object map_message_text = null;
        Node msgNode = null;
        AQxmlDebug.trace(5, "genXmlJmsMapMessage", "entry");
        msgNode = AQxmlGenUtil.msg_genXml((AQjmsMessage)msg, doc, node, msg_number);
        payload_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_payload");
        msgNode.appendChild(payload_node);
        map_message_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "jms_map_message");
        payload_node.appendChild(map_message_node);
        AQxmlGenUtil.gen_xml_oracle_jms_properties((AQjmsMessage)msg, doc, map_message_node);
        AQxmlGenUtil.gen_xml_user_properties((AQjmsMessage)msg, doc, map_message_node);
        AQxmlGenUtil.genXmlMapPayload((AQjmsMapMessage)msg, doc, map_message_node);
    }

    static void genXmlJmsTextMessage(Object msg, Document doc, Node node, int msg_number) {
        Element payloadNode = null;
        Element textMessageNode = null;
        Object textMessageText = null;
        Node msgNode = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlJmsTextMessage", "entry");
        msgNode = AQxmlGenUtil.msg_genXml((AQjmsMessage)msg, doc, node, msg_number);
        payloadNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_payload");
        msgNode.appendChild(payloadNode);
        textMessageNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "jms_text_message");
        payloadNode.appendChild(textMessageNode);
        AQxmlGenUtil.gen_xml_oracle_jms_properties((AQjmsMessage)msg, doc, textMessageNode);
        AQxmlGenUtil.gen_xml_user_properties((AQjmsMessage)msg, doc, textMessageNode);
        AQxmlGenUtil.genXmlTextPayload((AQjmsTextMessage)msg, doc, textMessageNode);
    }

    static void genXmlTextPayload(AQjmsTextMessage msg, Document doc, Node node) {
        Element textDataNode = null;
        Text textDataText = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlTextPayload", "entry");
        try {
            textDataNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "text_data");
            node.appendChild(textDataNode);
            textDataText = doc.createTextNode(msg.getText());
            textDataNode.appendChild(textDataText);
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlGenUtil:genxmlTextPayload", (Exception)((Object)jms_ex));
        }
    }

    static void genXmlMapPayload(AQjmsMapMessage msg, Document doc, Node node) {
        Element map_data_node = null;
        Enumeration my_enum = null;
        Element item_node = null;
        Element name_node = null;
        Text name_text = null;
        Element value_node = null;
        Text value_text = null;
        Object value = null;
        Object value_attr = null;
        String name = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlMapPayload", " entry");
        map_data_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "map_data");
        node.appendChild(map_data_node);
        try {
            my_enum = msg.getMapNames();
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlGenUtil: genXmlMapPayload-ex1:", (Exception)((Object)jms_ex));
        }
        while (my_enum.hasMoreElements()) {
            item_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "item");
            map_data_node.appendChild(item_node);
            name_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "name");
            item_node.appendChild(name_node);
            name = (String)my_enum.nextElement();
            name_text = doc.createTextNode(name);
            name_node.appendChild(name_text);
            try {
                value = msg.getObject(name);
            }
            catch (JMSException jms_ex) {
                AQxmlDebug.traceEx(3, "AQxmlGenUtil: genXmlMapPayload-ex2", (Exception)((Object)jms_ex));
            }
            if (value instanceof String) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "string_value");
            } else if (value instanceof Integer) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "int_value");
            } else if (value instanceof Long) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "long_value");
            } else if (value instanceof Double) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "double_value");
            } else if (value instanceof Boolean) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "boolean_value");
            } else if (value instanceof Float) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "float_value");
            } else if (value instanceof Short) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "short_value");
            } else if (value instanceof Byte) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "byte_value");
            }
            item_node.appendChild(value_node);
            value_text = doc.createTextNode(value.toString());
            value_node.appendChild(value_text);
        }
    }

    static void genXmlBytesPayload(AQjmsBytesMessage msg, Document doc, Node node) {
        Element bytesDataNode = null;
        Text bytesData = null;
        String hexString = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlBytesPayload", " entry");
        if (msg.getBytesData() != null) {
            bytesDataNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "bytes_data");
            node.appendChild(bytesDataNode);
            hexString = AQxmlRawMessage.bArray2String(msg.getBytesData());
            bytesData = doc.createTextNode(hexString);
            bytesDataNode.appendChild(bytesData);
        }
    }

    static void genXmlObjectPayload(AQjmsObjectMessage msg, Document doc, Node node) {
        Element objectDataNode = null;
        Text objectData = null;
        String hexString = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlObjectPayload", " entry");
        if (msg.getBytesData() != null) {
            AQxmlDebug.trace(4, "AQxmlGenUtil: genXmlObjectPayload", "bytes len: " + msg.getBytesData().length);
            objectDataNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "ser_object_data");
            node.appendChild(objectDataNode);
            hexString = AQxmlRawMessage.bArray2String(msg.getBytesData());
            objectData = doc.createTextNode(hexString);
            objectDataNode.appendChild(objectData);
        }
    }

    public static void genXml(AQjmsAgent ag, Document doc, Node node) {
        Element name_node = null;
        Text name_text = null;
        Element addr_node = null;
        Text addr_text = null;
        Element prot_node = null;
        Text prot_text = null;
        AQxmlDebug.trace(4, "AQxmlGenUtil: genXml(jmsagent)", " entry");
        try {
            if (ag.getName() != null) {
                name_text = doc.createTextNode(ag.getName());
                name_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "agent_name");
                node.appendChild(name_node);
                name_node.appendChild(name_text);
                AQxmlDebug.trace(5, "AQxmlGenUtil: genXml(jmsagent)", "agtname: " + ag.getName());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (ag.getAddress() != null) {
                addr_text = doc.createTextNode(ag.getAddress());
                addr_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "address");
                node.appendChild(addr_node);
                addr_node.appendChild(addr_text);
                AQxmlDebug.trace(5, "AQxmlGenUtil: genXml(jmsagent)", "agtaddr: " + ag.getAddress());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (ag.getProtocol() != 0) {
                prot_text = doc.createTextNode(String.valueOf(ag.getProtocol()));
                prot_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "protocol");
                node.appendChild(prot_node);
                prot_node.appendChild(prot_text);
                AQxmlDebug.trace(5, "AQxmlGenUtil: genXml(jmsagent)", "agtprot: " + ag.getProtocol());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void gen_xml_message_signature(AQjmsSignature sign, Document doc, Node node) {
        if (sign != null) {
            Element msgHeaderNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNATURE");
            node.appendChild(msgHeaderNode);
            try {
                byte[] sigval;
                byte[] digval;
                String sigalgo;
                Element SignInfoNode = null;
                boolean siginfo = false;
                String canalgo = sign.getCanalgo();
                if (canalgo != null) {
                    siginfo = true;
                    SignInfoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNEDINFO");
                    msgHeaderNode.appendChild(SignInfoNode);
                    Element CanalgoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "CANONICALIZATIONMETHOD");
                    CanalgoNode.setAttribute("algorithm", canalgo);
                    SignInfoNode.appendChild(CanalgoNode);
                }
                if ((sigalgo = sign.getSigalgo()) != null) {
                    if (!siginfo) {
                        SignInfoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNEDINFO");
                        msgHeaderNode.appendChild(SignInfoNode);
                        siginfo = true;
                    }
                    Element SigalgoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNATUREMETHOD");
                    SigalgoNode.setAttribute("algorithm", sigalgo);
                    SignInfoNode.appendChild(SigalgoNode);
                }
                String digalgo = sign.getDigalgo();
                boolean refinfo = false;
                Element ReferenceNode = null;
                if (digalgo != null) {
                    if (!siginfo) {
                        SignInfoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNEDINFO");
                        msgHeaderNode.appendChild(SignInfoNode);
                        siginfo = true;
                    }
                    ReferenceNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "REFERENCE");
                    SignInfoNode.appendChild(ReferenceNode);
                    refinfo = true;
                    Element DigalgoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "DIGESTMETHOD");
                    DigalgoNode.setAttribute("algorithm", digalgo);
                    ReferenceNode.appendChild(DigalgoNode);
                }
                if ((digval = sign.getDigval()) != null) {
                    if (!siginfo) {
                        SignInfoNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNEDINFO");
                        msgHeaderNode.appendChild(SignInfoNode);
                        siginfo = true;
                    }
                    if (!refinfo) {
                        ReferenceNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "REFERENCE");
                        SignInfoNode.appendChild(ReferenceNode);
                        refinfo = true;
                    }
                    Element DigvalNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "DIGESTVALUE");
                    String hexString = AQxmlRawMessage.bArray2String(digval);
                    Text rawData = doc.createTextNode(hexString);
                    DigvalNode.appendChild(rawData);
                }
                if ((sigval = sign.getSignature()) != null) {
                    Element SigvalNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "SIGNATUREVALUE");
                    String hexString = AQxmlRawMessage.bArray2String(sigval);
                    Text rawData = doc.createTextNode(hexString);
                    SigvalNode.appendChild(rawData);
                }
            }
            catch (SQLException jms_ex) {
                AQxmlDebug.traceEx(3, "AQxmlGenUtil.gen_xml_message_signature-ex1", jms_ex);
            }
        }
    }
}

