/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.util.Hashtable;
import oracle.jakarta.AQ.xml.AQxmlCommitResponse;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlFault;
import oracle.jakarta.AQ.xml.AQxmlPushResponse;
import oracle.jakarta.AQ.xml.AQxmlRollbackResponse;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumResponse;
import oracle.jakarta.AQ.xml.AQxmlServerResponse;
import oracle.jakarta.AQ.xml.AQxmlStatusResponse;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoResponse;
import oracle.jakarta.AQ.xml.StreamsAddTableRulesResponse;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AQxmlRespConverter {
    Document doc;
    int msg_type = -1;
    static Hashtable elementHashtable;

    public AQxmlDocument[] generateAQxmlDocument(NodeList nl) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        AQxmlDocument[] retDocs = null;
        Object local_name = null;
        Object namespace = null;
        NodeList cnl = null;
        int j = 0;
        this.printUtil("generateAQxmlDocument");
        AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Entry");
        AQxmlDebug.trace(5, "AQxmlRespConverter.generateAQxmlDocument", "NL: " + nl.getLength());
        retDocs = new AQxmlDocument[nl.getLength()];
        block9: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "NOT Null Element");
            switch (xmlElement) {
                case 312: {
                    retDocs[j] = new AQxmlPushResponse(null);
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                case 313: {
                    retDocs[j] = new AQxmlCommitResponse();
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                case 314: {
                    retDocs[j] = new AQxmlRollbackResponse();
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                case 315: {
                    retDocs[j] = new AQxmlSequenceNumResponse();
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                case 316: {
                    AQxmlDebug.trace(5, "AQxmlRespConverter.generateAQDocument", "queuetyperesponse");
                    retDocs[j] = new AQxmlTypeInfoResponse();
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                case 2230: {
                    AQxmlDebug.trace(5, "AQxmlRespConverter.generateAQDocument", "addtablerulesresponse");
                    retDocs[j] = new StreamsAddTableRulesResponse();
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                case 2040: {
                    AQxmlDebug.trace(5, "AQxmlRespConverter.generateAQDocument", "Fault");
                    retDocs[j] = new AQxmlFault(0, null, new AQxmlStatusResponse(0, 0, "NO ERROR"));
                    cnl = n.getChildNodes();
                    this.processResponse(cnl, retDocs[j]);
                    ++j;
                    continue block9;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        return retDocs;
    }

    void printNodeNSInfo(Node n) {
        AQxmlDebug.trace(5, "AQxmlRespConverter.printNodeNSInfo", "Expanded Name: " + ((XMLElement)n).getExpandedName());
        AQxmlDebug.trace(5, "AQxmlRespConverter.printNodeNSInfo", "Local Name: " + ((XMLElement)n).getLocalName());
        AQxmlDebug.trace(5, "AQxmlRespConverter.printNodeNSInfo", "Namespace: " + ((XMLElement)n).getNamespace());
        AQxmlDebug.trace(5, "AQxmlRespConverter.printNodeNSInfo", "Prefix: " + ((XMLElement)n).getPrefix());
        AQxmlDebug.trace(5, "AQxmlRespConverter.printNodeNSInfo", "Qualified NS: " + ((XMLElement)n).getQualifiedName());
    }

    boolean isAQNamespace(String ns) {
        AQxmlDebug.trace(5, "AQxmlRespConverter.isAQNamespace", "NS: " + ns);
        return ns.equalsIgnoreCase("http://ns.oracle.com/AQ/schemas/access");
    }

    boolean isIdapNamespace(String ns) {
        AQxmlDebug.trace(5, "AQxmlRespConverter.isIdapNamespace", "NS: " + ns);
        return ns.equalsIgnoreCase("http://ns.oracle.com/AQ/schemas/envelope");
    }

    Integer getNextAQElement(Node n) throws AQxmlException {
        Integer xmlElement = null;
        String nodename = null;
        String local_name = null;
        String namespace = null;
        nodename = n.getNodeName();
        local_name = ((XMLElement)n).getLocalName();
        namespace = ((XMLElement)n).getNamespace();
        AQxmlDebug.trace(5, "AQxmlRespConverter.genNextAQElement", "Full Node name: " + namespace + " " + local_name);
        xmlElement = (Integer)elementHashtable.get(local_name.toUpperCase());
        AQxmlDebug.trace(5, "AQxmlRespConverter.genNextAQElement", "XML ELEMENT: " + xmlElement);
        return xmlElement;
    }

    void processResponse(NodeList nlist, AQxmlDocument server_response) {
        int status_code = 0;
        int i = 0;
        Node n = null;
        Node n1 = null;
        Integer xmlElement = null;
        NodeList cnlist = null;
        Object nl = null;
        Integer fault_code = null;
        String fault_string = null;
        try {
            AQxmlDebug.trace(4, "AQxmlRespConverter.processResponse:", "enter");
            block12: for (i = 0; i < nlist.getLength(); ++i) {
                n = nlist.item(i);
                xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlRespConverter.processResponse", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 220: {
                        status_code = this.processStatusResponse(n.getChildNodes(), server_response);
                        continue block12;
                    }
                    case 1050: {
                        if (status_code != 0) continue block12;
                        cnlist = n.getChildNodes();
                        this.processPushResponse(cnlist, server_response);
                        continue block12;
                    }
                    case 1060: {
                        if (status_code != 0) continue block12;
                        cnlist = n.getChildNodes();
                        this.processSequenceNumResponse(cnlist, server_response);
                        continue block12;
                    }
                    case 1070: {
                        if (status_code != 0) continue block12;
                        cnlist = n.getChildNodes();
                        this.processQueueTypeResponse(cnlist, server_response);
                        continue block12;
                    }
                    case 2240: {
                        if (status_code != 0) continue block12;
                        cnlist = n.getChildNodes();
                        this.processAddTableRulesResponse(cnlist, server_response);
                        continue block12;
                    }
                    case 2050: {
                        n1 = n.getFirstChild();
                        fault_code = new Integer(n1.getNodeValue());
                        ((AQxmlFault)server_response).setFaultCode(fault_code);
                        continue block12;
                    }
                    case 2060: {
                        n1 = n.getFirstChild();
                        fault_string = n1.getNodeValue();
                        ((AQxmlFault)server_response).setFaultString(fault_string);
                    }
                    case 2070: {
                        n1 = n.getFirstChild();
                        status_code = this.processStatusResponse(n1.getChildNodes(), server_response);
                    }
                }
            }
        }
        catch (AQxmlException aQxmlException) {
            // empty catch block
        }
    }

    int processStatusResponse(NodeList nlist, AQxmlDocument server_response) {
        Node n = null;
        Node n1 = null;
        Integer status_code = null;
        Integer error_code = null;
        String acknowledge = null;
        int status = 0;
        Integer xmlElement = null;
        AQxmlStatusResponse stat_resp = null;
        stat_resp = server_response instanceof AQxmlFault ? ((AQxmlFault)server_response).getStatusResponse() : ((AQxmlServerResponse)server_response).getStatusResponse();
        for (int i = 0; i < nlist.getLength(); ++i) {
            try {
                n = nlist.item(i);
                xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 230: {
                        n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        acknowledge = n1.getNodeValue();
                        break;
                    }
                    case 240: {
                        n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        status_code = new Integer(n1.getNodeValue());
                        status = status_code;
                        stat_resp.setStatusCode(status);
                        break;
                    }
                    case 255: {
                        n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        error_code = new Integer(n1.getNodeValue());
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        stat_resp.setErrorCode(error_code);
                        break;
                    }
                    case 250: {
                        n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        stat_resp.setErrorMessage(n1.getNodeValue());
                    }
                }
                continue;
            }
            catch (AQxmlException aQxmlException) {
                // empty catch block
            }
        }
        return status;
    }

    void processPushResponse(NodeList nlist, AQxmlDocument server_response) {
        Integer xmlElement = null;
        Node n = null;
        Node n1 = null;
        AQxmlPushResponse pushR = (AQxmlPushResponse)server_response;
        for (int i = 0; i < nlist.getLength(); ++i) {
            try {
                n = nlist.item(i);
                xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 60: {
                        n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        pushR.setDestination(n1.getNodeValue());
                        break;
                    }
                    case 150: {
                        n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        pushR.setMessageId(n1.getNodeValue());
                        break;
                    }
                }
                continue;
            }
            catch (AQxmlException aQxmlException) {
                // empty catch block
            }
        }
    }

    void processSequenceNumResponse(NodeList nlist, AQxmlDocument server_response) {
        Integer xmlElement = null;
        AQxmlSequenceNumResponse seq_resp = (AQxmlSequenceNumResponse)server_response;
        for (int i = 0; i < nlist.getLength(); ++i) {
            try {
                Node n = nlist.item(i);
                xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 270: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        seq_resp.setSequenceNumber(n1.getNodeValue());
                        break;
                    }
                    case 890: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        seq_resp.setDatabaseLink(n1.getNodeValue());
                    }
                }
                continue;
            }
            catch (AQxmlException aQxmlException) {
                // empty catch block
            }
        }
    }

    void processAddTableRulesResponse(NodeList nlist, AQxmlDocument server_response) {
        Integer xmlElement = null;
        StreamsAddTableRulesResponse resp = (StreamsAddTableRulesResponse)server_response;
        for (int i = 0; i < nlist.getLength(); ++i) {
            try {
                Node n = nlist.item(i);
                xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 2250: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        resp.setDmlRuleName(n1.getNodeValue());
                        break;
                    }
                    case 2260: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        resp.setDdlRuleName(n1.getNodeValue());
                    }
                }
                continue;
            }
            catch (AQxmlException aQxmlException) {
                // empty catch block
            }
        }
    }

    void processQueueTypeResponse(NodeList nlist, AQxmlDocument server_response) {
        AQxmlTypeInfoResponse typ_resp = (AQxmlTypeInfoResponse)server_response;
        for (int i = 0; i < nlist.getLength(); ++i) {
            try {
                Node n = nlist.item(i);
                Integer xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlRespConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 60: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        typ_resp.setDestination(n1.getNodeValue());
                        break;
                    }
                    case 1080: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        typ_resp.setReturnCode(n1.getNodeValue());
                        break;
                    }
                    case 1090: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        typ_resp.setTypeId(n1.getNodeValue());
                        break;
                    }
                    case 2000: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        typ_resp.setVersion(n1.getNodeValue());
                        break;
                    }
                    case 2010: {
                        Node n1 = n.getFirstChild();
                        AQxmlDebug.println(n1.getNodeName() + " = " + n1.getNodeValue());
                        typ_resp.setTypeDescriptor(n1.getNodeValue());
                        break;
                    }
                }
                continue;
            }
            catch (AQxmlException aQxmlException) {
                // empty catch block
            }
        }
    }

    NodeList getNodeList(NodeList nl, String node_name) throws AQxmlException {
        Node n = null;
        Object n_name = null;
        NodeList ret_nl = null;
        int i = 0;
        String n_local_name = null;
        AQxmlDebug.trace(5, "AQxmlRespConverter.getNodeList", "NL: " + nl.getLength());
        n = nl.item(i);
        n_local_name = ((XMLElement)n).getLocalName();
        while (!n_local_name.equalsIgnoreCase(node_name)) {
            n = nl.item(++i);
            n_local_name = ((XMLElement)n).getLocalName();
        }
        if (n_local_name.equalsIgnoreCase(node_name)) {
            ret_nl = n.getChildNodes();
        } else {
            AQxmlDebug.trace(4, "AQxmlRespConverter.getNodeList", "Error: node is not " + node_name);
            AQxmlError.throwAQEx(401, node_name + " Node not found");
        }
        return ret_nl;
    }

    public void printUtil(String function_name) {
        AQxmlDebug.trace(5, " ", " ");
        AQxmlDebug.trace(5, " ", " ");
        AQxmlDebug.trace(5, " ", "------------------------------------------------");
        AQxmlDebug.trace(5, " ", "         " + function_name + "             ");
        AQxmlDebug.trace(5, " ", "------------------------------------------------");
        AQxmlDebug.trace(5, " ", " ");
    }

    String getAttributeValue(Node n, String attributename) {
        XMLElement e = (XMLElement)n;
        Attr attribute = e.getAttributeNode(attributename);
        AQxmlDebug.trace(5, "AQxmlRespConverter.getAttributeValue", "Attribute Name : " + attribute.getName());
        AQxmlDebug.trace(5, "AQxmlRespConverter.getAttributeValue", "Attribute Value: " + attribute.getValue());
        return attribute.getValue();
    }

    String getTextNodeValue(Node n) {
        Node ln = n.getLastChild();
        return ln.getNodeValue();
    }

    private static void initElementHashtable() {
        elementHashtable = new Hashtable();
        elementHashtable.put("AQXMLDOCUMENT", new Integer(10));
        elementHashtable.put("SERVER_PROP_OPERATION", new Integer(15));
        elementHashtable.put("CLIENT_OPERATION", new Integer(20));
        elementHashtable.put("SERVER_OPERATION", new Integer(40));
        elementHashtable.put("DESTINATION", new Integer(60));
        elementHashtable.put("STATUS_RESPONSE", new Integer(220));
        elementHashtable.put("ACKNOWLEDGE", new Integer(230));
        elementHashtable.put("STATUS_CODE", new Integer(240));
        elementHashtable.put("ERROR_MESSAGE", new Integer(250));
        elementHashtable.put("SEQUENCE_INFO", new Integer(260));
        elementHashtable.put("SEQUENCE_NUMBER", new Integer(270));
        elementHashtable.put("SEND_RESULT", new Integer(320));
        elementHashtable.put("PUBLISH_RESULT", new Integer(330));
        elementHashtable.put("RECEIVE_RESULT", new Integer(340));
        elementHashtable.put("AQXMLSEND", new Integer(620));
        elementHashtable.put("AQXMLRECEIVE", new Integer(630));
        elementHashtable.put("AQXMLPUBLISH", new Integer(640));
        elementHashtable.put("AQXMLREGISTER", new Integer(650));
        elementHashtable.put("DATABASE", new Integer(660));
        elementHashtable.put("AQXMLROLLBACK", new Integer(690));
        elementHashtable.put("DBLINK", new Integer(890));
        elementHashtable.put("SOURCE_QID", new Integer(900));
        elementHashtable.put("AQXMLPUSHRESPONSE", new Integer(312));
        elementHashtable.put("AQXMLCOMMITRESPONSE", new Integer(313));
        elementHashtable.put("AQXMLROLLBACKRESPONSE", new Integer(314));
        elementHashtable.put("AQXMLSEQUENCENUMBERRESPONSE", new Integer(315));
        elementHashtable.put("AQXMLQUEUETYPERESPONSE", new Integer(316));
        elementHashtable.put("QUEUE_TYPE_RESULT", new Integer(1070));
        elementHashtable.put("SEQUENCE_NUM_RESULT", new Integer(1060));
        elementHashtable.put("PUSH_RESULT", new Integer(1050));
        elementHashtable.put("VERSION", new Integer(2000));
        elementHashtable.put("RETURNCODE", new Integer(1080));
        elementHashtable.put("TYPEID", new Integer(1090));
        elementHashtable.put("TYPEDESCRIPTOR", new Integer(2010));
        elementHashtable.put("MESSAGE_ID", new Integer(150));
        elementHashtable.put("FAULT", new Integer(2040));
        elementHashtable.put("FAULTCODE", new Integer(2050));
        elementHashtable.put("FAULTSTRING", new Integer(2060));
        elementHashtable.put("DETAIL", new Integer(2070));
        elementHashtable.put("ERROR_CODE", new Integer(255));
        elementHashtable.put("STREAMSADDTABLERULESRESPONSE", new Integer(2230));
        elementHashtable.put("ADD_TABLE_RULES_RESULT", new Integer(2230));
        elementHashtable.put("DML_RULE_NAME", new Integer(2250));
        elementHashtable.put("DDL_RULE_NAME", new Integer(2260));
    }

    public static byte[] convertHexStringToByte(String refString) {
        byte[] byteArray = new byte[refString.length() / 2];
        for (int i = 0; i < refString.length(); i += 2) {
            int intVal = AQxmlRespConverter.convertCharToInt(refString.charAt(i));
            Integer newInt = new Integer(0xF0 & intVal << 4);
            byteArray[i / 2] = newInt.byteValue();
            intVal = AQxmlRespConverter.convertCharToInt(refString.charAt(i + 1));
            newInt = new Integer(0xF & intVal);
            int n = i / 2;
            byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
        }
        return byteArray;
    }

    private static int convertCharToInt(char charVal) {
        switch (charVal) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 48;
    }

    static {
        AQxmlRespConverter.initElementHashtable();
    }
}

