/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import oracle.jakarta.AQ.xml.AQxmlConverter;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlFault;
import oracle.jakarta.AQ.xml.AQxmlGenConverter;
import oracle.jakarta.AQ.xml.AQxmlGenerator;
import oracle.jakarta.AQ.xml.AQxmlSoapResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;

class AQxmlSoapConverter
extends AQxmlGenConverter {
    static Hashtable envelopeHashtable;
    Document doc;
    String schema_loc;
    Object schema_obj;

    AQxmlSoapConverter() {
        this(null);
    }

    AQxmlSoapConverter(Document document) {
        AQxmlDebug.trace(4, "AQxmlSoapConverter.constructor", "Entry");
        this.doc = document;
        this.schema_loc = null;
        this.schema_obj = null;
    }

    @Override
    public String getNamespace() {
        return "http://schemas.xmlsoap.org/soap/envelope/";
    }

    @Override
    public String getSchemaLocation() {
        return this.schema_loc;
    }

    public void setSchemaLocation(String schema_location) throws AQxmlException {
        this.schema_loc = schema_location;
    }

    @Override
    public synchronized Object getSchemaObject() throws AQxmlException {
        XSDBuilder bd = null;
        URL sch_url = null;
        XMLSchema curr_sch_obj = null;
        AQxmlSoapResolver rs = null;
        InputStream istream = null;
        AQxmlDebug.trace(4, "AQxmlSoapConverter.createSchemaBuilder", "entry");
        if (this.schema_obj != null) {
            AQxmlDebug.trace(4, "AQxmlSoapConverter.createSchemaBuilder", "exit returning current sch_obj=" + this.schema_obj);
            return this.schema_obj;
        }
        try {
            bd = new XSDBuilder();
            if (this.schema_loc != null) {
                AQxmlDebug.trace(4, "AQxmlSoapConverter.createSchemaBuilder", "schema loc: " + this.schema_loc);
                sch_url = AQxmlConverter.createURL(this.schema_loc);
                curr_sch_obj = bd.build(sch_url);
                curr_sch_obj.buildSchemaPathTable();
                AQxmlDebug.trace(4, "AQxmlSoapConverter.createSchemaBuilder", "build with url successful");
            } else {
                rs = new AQxmlSoapResolver();
                bd.setEntityResolver((EntityResolver)rs);
                istream = this.getClass().getResourceAsStream("aqxml.xsd");
                curr_sch_obj = bd.build(istream, null);
                curr_sch_obj.buildSchemaPathTable();
                AQxmlDebug.trace(4, "AQxmlSoapConverter.createSchemaBuilder", "default build successful");
            }
        }
        catch (MalformedURLException mf_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSoapConverter.createSchemaBuilder-mf-ex", mf_ex);
            AQxmlError.throwAQEx(435, mf_ex);
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(3, "AQxmlSoapConverter.createSchemaBuilder-ex", ex);
            AQxmlError.throwAQEx(439, ex);
        }
        AQxmlDebug.trace(4, "AQxmlSoapConverter.createSchemaBuilder", "exit returning new sch_obj=" + curr_sch_obj);
        this.schema_obj = curr_sch_obj;
        return this.schema_obj;
    }

    @Override
    public AQxmlDocument[] generateAQxmlDocument(Document dom_doc) throws AQxmlException {
        this.doc = dom_doc;
        return this.generateAQxmlDocument();
    }

    AQxmlDocument[] generateAQxmlDocument() throws AQxmlException {
        NodeList root_cnl = null;
        Node n = null;
        Integer xmlElement = null;
        NodeList cnl = null;
        AQxmlConverter conv = null;
        AQxmlDocument[] retDocs = null;
        AQxmlDebug.trace(4, "AQxmlSoapConverter.generateAQxmlDocument", "Entry");
        if (this.doc == null) {
            AQxmlDebug.trace(4, "AQxmlSoapConverter.generateAQxmlDocument", "Null doc");
        }
        root_cnl = this.getRootNodeList();
        try {
            AQxmlDebug.trace(5, "AQxmlSoapConverter.generateAQxmlDocument", "NL: " + root_cnl.getLength());
            block7: for (int i = 0; i < root_cnl.getLength(); ++i) {
                n = root_cnl.item(i);
                xmlElement = this.getNextSoapElement(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlSoapConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 1020: {
                        AQxmlDebug.trace(5, "AQxmlSoapConverter.generateAQxmlDocument", "ENVELOPE");
                        continue block7;
                    }
                    case 1000: {
                        cnl = n.getChildNodes();
                        conv = new AQxmlConverter();
                        retDocs = conv.generateAQxmlDocument(cnl);
                        continue block7;
                    }
                    case 1010: {
                        continue block7;
                    }
                    default: {
                        AQxmlError.throwAQEx(422, n.getNodeName());
                    }
                }
            }
        }
        catch (AQxmlException aqxml_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSoapConverter.generateAQxmlDocument-aqxml_ex", aqxml_ex);
            throw aqxml_ex;
        }
        return retDocs;
    }

    @Override
    public void generateDOMDocument(Document response_doc, AQxmlDocument[] aqxml_docs) throws AQxmlException {
        Element root_elem = null;
        Element body_node = null;
        Element root_node = null;
        AQxmlGenerator aqgen = null;
        AQxmlDebug.trace(4, "AQxmlSoapConverter.generateDOMDocument", "entry");
        ((XMLDocument)response_doc).setVersion("1.0");
        root_elem = ((XMLDocument)response_doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        ((XMLElement)root_elem).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/soap/envelope/");
        response_doc.appendChild(root_elem);
        root_node = response_doc.getDocumentElement();
        body_node = ((XMLDocument)response_doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        root_node.appendChild(body_node);
        aqgen = new AQxmlGenerator();
        for (int i = 0; i < aqxml_docs.length && aqxml_docs[i] != null; ++i) {
            if (aqxml_docs[i] instanceof AQxmlFault) {
                this.genFaultXml(response_doc, (AQxmlFault)aqxml_docs[i], body_node, aqgen);
                continue;
            }
            aqgen.generateDOMDocument(response_doc, aqxml_docs[i], body_node);
        }
        AQxmlDebug.trace(4, "AQxmlSoapConverter.generateDOMDocument", "exit");
    }

    @Override
    public void generateDOMDocument(Document response_doc, AQxmlDocument aqxml_doc) throws AQxmlException {
        Element root_elem = null;
        Element body_node = null;
        Element root_node = null;
        AQxmlGenerator aqgen = null;
        AQxmlDebug.trace(4, "AQxmlSoapConverter.generateDOMDocument", "entry");
        ((XMLDocument)response_doc).setVersion("1.0");
        root_elem = ((XMLDocument)response_doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        ((XMLElement)root_elem).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/soap/envelope/");
        response_doc.appendChild(root_elem);
        root_node = response_doc.getDocumentElement();
        body_node = ((XMLDocument)response_doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        root_node.appendChild(body_node);
        aqgen = new AQxmlGenerator();
        if (aqxml_doc instanceof AQxmlFault) {
            this.genFaultXml(response_doc, (AQxmlFault)aqxml_doc, body_node, aqgen);
        } else {
            aqgen.generateDOMDocument(response_doc, aqxml_doc, body_node);
        }
        AQxmlDebug.trace(4, "AQxmlSoapConverter.generateDOMDocument", "exit");
    }

    @Override
    public synchronized AQxmlGenConverter cloneConverter() throws AQxmlException {
        AQxmlSoapConverter cl_conv = null;
        cl_conv = new AQxmlSoapConverter();
        cl_conv.schema_loc = this.schema_loc;
        cl_conv.schema_obj = this.schema_obj;
        return cl_conv;
    }

    void setDocument(Document document) {
        this.doc = document;
    }

    NodeList getRootNodeList() {
        NodeList root_nl = null;
        Node root_node = null;
        String nodename = null;
        NodeList root_cnl = null;
        root_nl = this.doc.getElementsByTagName("*");
        root_node = root_nl.item(0);
        nodename = root_node.getNodeName();
        AQxmlDebug.trace(5, "AQxmlSoapConverter.getRootNodeList", "Root Node name: " + nodename);
        root_cnl = root_node.getChildNodes();
        return root_cnl;
    }

    Integer getNextSoapElement(Node n) throws AQxmlException {
        Integer xmlElement = null;
        String nodename = null;
        String local_name = null;
        Object namespace = null;
        nodename = n.getNodeName();
        AQxmlDebug.trace(5, "AQxmlSoapConverter.genNextSoapElement", "Node name: " + nodename);
        local_name = ((XMLElement)n).getLocalName();
        AQxmlDebug.trace(5, "AQxmlSoapConverter.genNextSoapElement", "Node Local Name: " + local_name);
        xmlElement = (Integer)envelopeHashtable.get(local_name.toUpperCase());
        AQxmlDebug.trace(5, "AQxmlSoapConverter.genProducerOption", "XML ELEMENT: " + xmlElement);
        return xmlElement;
    }

    void genFaultXml(Document doc, AQxmlFault aqxml_doc, Node soap_body_node, AQxmlGenerator aqgen) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlSoapConverter.genFaultXml", "entry");
        XMLElement fault_elem = null;
        Text fc_text = null;
        Element fc_node = null;
        Text fs_text = null;
        Element fs_node = null;
        Element detail_node = null;
        fault_elem = new XMLElement("Fault", "", "http://schemas.xmlsoap.org/soap/envelope/");
        fault_elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/soap/envelope/");
        if (soap_body_node == null) {
            AQxmlError.throwAQEx(401, "Soap Body Node: Null");
        }
        soap_body_node.appendChild((Node)fault_elem);
        fc_node = ((XMLDocument)doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultcode");
        fault_elem.appendChild(fc_node);
        fc_text = doc.createTextNode(String.valueOf(aqxml_doc.getFaultCode()));
        fc_node.appendChild(fc_text);
        fs_node = ((XMLDocument)doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultstring");
        fault_elem.appendChild(fs_node);
        fs_text = doc.createTextNode(aqxml_doc.getFaultString());
        fs_node.appendChild(fs_text);
        detail_node = ((XMLDocument)doc).createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "detail");
        fault_elem.appendChild(detail_node);
        aqgen.genStatusResponseXml(doc, aqxml_doc.getStatusResponse(), detail_node);
        AQxmlDebug.trace(4, "AQxmlSoapConverter.genFaultXml", "exit");
    }

    private static void initEnvelopeHashtable() {
        envelopeHashtable = new Hashtable();
        envelopeHashtable.put("BODY", new Integer(1000));
        envelopeHashtable.put("HEADER", new Integer(1010));
        envelopeHashtable.put("ENVELOPE", new Integer(1020));
    }

    static {
        AQxmlSoapConverter.initEnvelopeHashtable();
    }
}

