/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.jakarta.jms.AQjmsProducer;
import oracle.jakarta.jms.AQjmsSession;

public class AQjmsJMSProducer
implements JMSProducer {
    AQjmsSession session;
    AQjmsProducer producer;
    String correlationID;
    byte[] correlationIDBytes;
    String type;
    Destination replyTo;
    private long deliveryDelay = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    CompletionListener completionListener;
    private final HashMap<String, Object> messageProperties = new HashMap();

    AQjmsJMSProducer(AQjmsSession session, AQjmsProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    public JMSProducer clearProperties() {
        this.messageProperties.clear();
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public boolean getBooleanProperty(String arg0) {
        return false;
    }

    public byte getByteProperty(String arg0) {
        return 0;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public boolean getDisableMessageID() {
        return this.disableMessageId;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableTimestamp;
    }

    public double getDoubleProperty(String arg0) {
        return 0.0;
    }

    public float getFloatProperty(String arg0) {
        return 0.0f;
    }

    public int getIntProperty(String arg0) {
        return 0;
    }

    public String getJMSCorrelationID() {
        return null;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationIDBytes;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public String getJMSType() {
        return this.type;
    }

    public long getLongProperty(String arg0) {
        return 0L;
    }

    public Object getObjectProperty(String arg0) {
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.messageProperties.keySet());
    }

    public short getShortProperty(String arg0) {
        return 0;
    }

    public String getStringProperty(String arg0) {
        return null;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean propertyExists(String name) {
        return this.messageProperties.containsKey(name);
    }

    public JMSProducer send(Destination destination, Message message) {
        try {
            this.doSend(destination, message);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to send message", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer send(Destination destination, String strMessage) {
        try {
            TextMessage message = this.session.createTextMessage(strMessage);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to send message", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> mapMessage) {
        try {
            MapMessage message = this.session.createMapMessage();
            if (mapMessage != null) {
                for (Map.Entry<String, Object> entry : mapMessage.entrySet()) {
                    message.setObject(entry.getKey(), entry.getValue());
                }
            }
            this.doSend(destination, (Message)message);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to send message", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer send(Destination destination, byte[] byteMessage) {
        try {
            BytesMessage message = this.session.createBytesMessage();
            if (byteMessage != null) {
                message.writeBytes(byteMessage);
            }
            this.doSend(destination, (Message)message);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to send message", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer send(Destination destination, Serializable message) {
        try {
            ObjectMessage objectMessage = this.session.createObjectMessage();
            objectMessage.setObject(message);
            this.doSend(destination, (Message)objectMessage);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to send message", e.getErrorCode());
        }
        return this;
    }

    private void doSend(Destination destination, Message message) throws JMSException {
        if (message == null) {
            throw new MessageFormatException("Message must not be null");
        }
        for (Map.Entry<String, Object> entry : this.messageProperties.entrySet()) {
            message.setObjectProperty(entry.getKey(), entry.getValue());
        }
        if (this.correlationID != null) {
            message.setJMSCorrelationID(this.correlationID);
        }
        if (this.correlationIDBytes != null) {
            message.setJMSCorrelationIDAsBytes(this.correlationIDBytes);
        }
        if (this.type != null) {
            message.setJMSType(this.type);
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        if (this.getAsync() == null) {
            this.producer.send(destination, message);
        } else {
            this.producer.send(destination, message, this.completionListener);
        }
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        try {
            this.producer.setDeliveryDelay(deliveryDelay);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to set DeliveryDelay", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public JMSProducer setDisableMessageID(boolean disableMessageId) {
        this.disableMessageId = disableMessageId;
        try {
            this.producer.setDisableMessageID(disableMessageId);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to set DisableMessageID", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableTimestamp) {
        this.disableTimestamp = disableTimestamp;
        try {
            this.producer.setDisableMessageTimestamp(disableTimestamp);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to set DisableMessageTimestamp", e.getErrorCode());
        }
        return this;
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.correlationID = correlationID;
        return this;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationIDBytes) {
        this.correlationIDBytes = correlationIDBytes;
        return this;
    }

    public JMSProducer setJMSReplyTo(Destination arg0) {
        return null;
    }

    public JMSProducer setJMSType(String type) {
        this.type = type;
        return this;
    }

    public JMSProducer setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.setObjectProperty(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        try {
            this.producer.setTimeToLive(timeToLive);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to set TimeToLive", e.getErrorCode());
        }
        return this;
    }

    void checkPropertyName(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name can not be null or empty string");
        }
    }

    void checkValidObject(Object value) {
        boolean valid;
        boolean bl = valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            throw new IllegalArgumentException("Only objectified primitive objects and String types are allowed. Given: " + value + " type: " + value.getClass());
        }
    }

    JMSProducer setObjectProperty(String name, Object value) {
        this.checkPropertyName(name);
        this.checkValidObject(value);
        this.messageProperties.put(name, value);
        return this;
    }
}

